/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.InputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.xml.PomModel;
import org.drools.compiler.kproject.xml.PomModelGenerator;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.embedder.MavenProjectLoader;

public class MavenPomModelGenerator
implements PomModelGenerator {
    public PomModel parse(String path, InputStream pomStream) {
        return new MavenModel(MavenProjectLoader.parseMavenPom(pomStream));
    }

    public static class MavenModel
    extends PomModel.InternalModel {
        private final MavenProject mavenProject;

        public MavenModel(MavenProject mavenProject) {
            this.mavenProject = mavenProject;
            this.setReleaseId(this.initReleaseId(mavenProject));
            this.setParentReleaseId(this.initParentReleaseId(mavenProject));
            this.initDependencies(mavenProject);
        }

        public MavenProject getMavenProject() {
            return this.mavenProject;
        }

        private ReleaseId initReleaseId(MavenProject mavenProject) {
            return new ReleaseIdImpl(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
        }

        private ReleaseId initParentReleaseId(MavenProject mavenProject) {
            try {
                MavenProject parentProject = mavenProject.getParent();
                if (parentProject != null) {
                    return new ReleaseIdImpl(parentProject.getGroupId(), parentProject.getArtifactId(), parentProject.getVersion());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private void initDependencies(MavenProject mavenProject) {
            for (Artifact dep : mavenProject.getArtifacts()) {
                this.addDependency((ReleaseId)new ReleaseIdImpl(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType()), dep.getScope());
            }
        }
    }
}

