/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.MavenRepository;
import org.kie.scanner.embedder.MavenEmbedderUtils;

@RunWith(value=Parameterized.class)
public class KieRepositoryScannerTest
extends AbstractKieCiTest {
    private final boolean useWiredComponentProvider;
    private FileManager fileManager;

    @Parameterized.Parameters(name="Manually wired component provider={0}")
    public static Collection modes() {
        Object[][] manuallyWiredProvider = new Object[][]{{true}, {false}};
        return Arrays.asList(manuallyWiredProvider);
    }

    public KieRepositoryScannerTest(boolean useWiredComponentProvider) {
        this.useWiredComponentProvider = useWiredComponentProvider;
    }

    @Before
    public void setUp() throws Exception {
        MavenEmbedderUtils.enforceWiredComponentProvider = this.useWiredComponentProvider;
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
        MavenEmbedderUtils.enforceWiredComponentProvider = false;
    }

    private void resetFileManager() {
        this.fileManager.tearDown();
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @Test
    public void testKScanner() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, "rule1", "rule2");
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1", "rule2");
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId, "rule2", "rule3");
        repository.installArtifact(releaseId, kJar2, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieScanner scanner = ks.newKieScanner(kieContainer);
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, "rule2", "rule3");
        ks.getRepository().removeKieModule(releaseId);
    }

    @Test
    @Ignore(value="used only for check performances")
    public void testKScannerWithDependencies() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseIdNoDep = ks.newReleaseId("org.kie", "test-no-dep", "1.0-SNAPSHOT");
        ReleaseId releaseIdWithDep = ks.newReleaseId("org.kie", "test-with-dep", "1.0-SNAPSHOT");
        long start = System.nanoTime();
        InternalKieModule kJar1 = this.createKieJar(ks, releaseIdNoDep, false, "rule1");
        KieContainer kieContainer1 = ks.newKieContainer(releaseIdNoDep);
        System.out.println("done in " + (System.nanoTime() - start));
        ReleaseId dep1 = ks.newReleaseId("org.slf4j", "slf4j-api", "1.7.2");
        ReleaseId dep2 = ks.newReleaseId("com.google.gwt", "gwt-user", "2.7.0");
        ReleaseId dep3 = ks.newReleaseId("org.hibernate", "hibernate-validator", "4.1.0.Final");
        start = System.nanoTime();
        InternalKieModule kJar2 = this.createKieJarWithDependencies(ks, releaseIdWithDep, false, "rule1", dep1, dep2, dep3);
        KieContainer kieContainer2 = ks.newKieContainer(releaseIdWithDep);
        System.out.println("done in " + (System.nanoTime() - start));
    }

    @Test
    public void testKieScannerScopesNotRequired() throws Exception {
        MavenRepository repository = MavenRepository.getMavenRepository();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseIdWithDep = ks.newReleaseId("org.kie", "test-with-dep", "1.0-SNAPSHOT");
        Dependency dep1 = this.dependencyWithScope("org.kie", "test-dep1-in-test-scope", "1.0-SNAPSHOT", "test");
        Dependency dep2 = this.dependencyWithScope("org.kie", "test-dep2-in-provided-scope", "1.0-SNAPSHOT", "provided");
        Dependency dep3 = this.dependencyWithScope("org.kie", "test-dep3-in-system-scope", "1.0-SNAPSHOT", "system");
        dep3.setSystemPath(this.fileManager.getRootDirectory().getAbsolutePath());
        repository.installArtifact(ks.newReleaseId("org.kie", "test-dep3-in-system-scope", "1.0-SNAPSHOT"), new byte[0], new byte[0]);
        InternalKieModule kJar2 = this.createKieJarWithDependencies(ks, releaseIdWithDep, false, "rule1", dep1, dep2, dep3);
        KieContainer kieContainer = ks.newKieContainer(releaseIdWithDep);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        Assert.assertNotNull((Object)scanner);
    }

    @Test
    public void testKScannerStartNotDeployed() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-start-not-deployed-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, "rule1", "rule2");
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        scanner.scanNow();
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1", "rule2");
    }

    @Test
    public void testKScannerWithRange() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "scanner-range-test", "1.0.1");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "scanner-range-test", "1.0.2");
        ReleaseId releaseRange = ks.newReleaseId("org.kie", "scanner-range-test", "[1.0.0,)");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId1, "rule1", "rule2");
        KieContainer kieContainer = ks.newKieContainer(releaseRange);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId1, kJar1, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1", "rule2");
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId2, "rule2", "rule3");
        repository.installArtifact(releaseId2, kJar2, this.createKPom(this.fileManager, releaseId2, new ReleaseId[0]));
        InternalKieScanner scanner = (InternalKieScanner)ks.newKieScanner(kieContainer);
        Assert.assertEquals((Object)releaseId1, (Object)scanner.getCurrentReleaseId());
        Assert.assertEquals((Object)InternalKieScanner.Status.STOPPED, (Object)scanner.getStatus());
        scanner.scanNow();
        Assert.assertEquals((Object)releaseId2, (Object)scanner.getCurrentReleaseId());
        Assert.assertEquals((Object)InternalKieScanner.Status.STOPPED, (Object)scanner.getStatus());
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, "rule2", "rule3");
        ks.getRepository().removeKieModule(releaseId1);
        ks.getRepository().removeKieModule(releaseId2);
    }

    @Test
    public void testKScannerWithKJarContainingClasses() throws Exception {
        this.testKScannerWithType(false);
    }

    @Test
    public void testKScannerWithKJarContainingTypeDeclaration() throws Exception {
        this.testKScannerWithType(true);
    }

    private void testKScannerWithType(boolean useTypeDeclaration) throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, releaseId, useTypeDeclaration, 2, 7, new ReleaseId[0]);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, 14);
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, releaseId, useTypeDeclaration, 3, 5, new ReleaseId[0]);
        repository.installArtifact(releaseId, kJar2, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, 15);
        ks.getRepository().removeKieModule(releaseId);
    }

    @Test
    public void testKScannerWithFunction() throws Exception {
        String drl1 = "global java.util.List list;\n\nfunction boolean doSomething(String name) {\n    return true ;\n}\n \nrule R1 when\n    $s : String( )\n    eval(doSomething($s))\nthen\n    list.add(\"XXX:\" + $s);\nend";
        String drl2 = "global java.util.List list;\n\nfunction boolean doSomething(String name) {\n    return true ;\n}\n \nrule R1 when\n    $s : String( )\n    eval(doSomething($s))\nthen\n    list.add(\"YYY:\" + $s);\nend";
        this.checkUpdateDRLInSameSession(drl1, drl2);
    }

    @Test
    public void testKScannerWithNewFunction() throws Exception {
        String drl1 = "global java.util.List list;\n\n \nrule R1 when\n    $s : String( )\nthen\n    list.add(\"XXX:\" + $s);\nend";
        String drl2 = "global java.util.List list;\n\nfunction boolean doSomething(String name) {\n    return true ;\n}\n \nrule R1 when\n    $s : String( )\n    eval(doSomething($s))\nthen\n    list.add(\"YYY:\" + $s);\nend";
        this.checkUpdateDRLInSameSession(drl1, drl2);
    }

    private void checkUpdateDRLInSameSession(String drl1, String drl2) throws IOException {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJarFromDrl(ks, releaseId, drl1);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        KieSession ksession = kieContainer.newKieSession("KSession1");
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"111");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"XXX:111", list.get(0));
        list.clear();
        InternalKieModule kJar2 = this.createKieJarFromDrl(ks, releaseId, drl2);
        repository.installArtifact(releaseId, kJar2, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        scanner.scanNow();
        ksession.insert((Object)"222");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("YYY:111", "YYY:222")));
        ks.getRepository().removeKieModule(releaseId);
    }

    private InternalKieModule createKieJarFromDrl(KieServices ks, ReleaseId releaseId, String drl) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        kfs.write("src/main/resources/KBase1/rule1.drl", drl);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    @Test
    public void testLoadKieJarFromMavenRepo() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
        String drl = " global java.util.List list; \n rule R1 \n when \n     not(String()) \n then \n     list.add(15);\n end ";
        InternalKieModule kJar1 = this.createKieJarFromDrl(ks, releaseId, " global java.util.List list; \n rule R1 \n when \n     not(String()) \n then \n     list.add(15);\n end ");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, 15);
        ks.getRepository().removeKieModule(releaseId);
    }

    @Test
    public void testScannerOnPomProject() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "scanner-test", "1.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "scanner-test", "2.0");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployPomArtifact("org.kie", "scanner-master-test", "1.0", this.createMasterKPom("scanner-test"));
        this.resetFileManager();
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, releaseId1, false, 2, 7, new ReleaseId[0]);
        repository.installArtifact(releaseId1, kJar1, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        KieContainer kieContainer = ks.newKieContainer(ks.newReleaseId("org.kie", "scanner-master-test", "LATEST"));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, 14);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, releaseId2, false, 3, 5, new ReleaseId[0]);
        repository.installArtifact(releaseId2, kJar2, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, 15);
        ks.getRepository().removeKieModule(releaseId1);
        ks.getRepository().removeKieModule(releaseId2);
    }

    @Test
    public void testScannerOnPomProjectWithFixedVersion() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "scanner-test", "1.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "scanner-test", "2.0");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployPomArtifact("org.kie", "scanner-master-test", "1.0", this.createMasterKPom("scanner-test", "1.0"));
        this.resetFileManager();
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, releaseId1, false, 2, 7, new ReleaseId[0]);
        repository.installArtifact(releaseId1, kJar1, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        KieContainer kieContainer = ks.newKieContainer(ks.newReleaseId("org.kie", "scanner-master-test", "LATEST"));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, 14);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        repository.deployPomArtifact("org.kie", "scanner-master-test", "2.0", this.createMasterKPom("scanner-test", "2.0"));
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, releaseId2, false, 3, 5, new ReleaseId[0]);
        repository.installArtifact(releaseId2, kJar2, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, 15);
        ks.getRepository().removeKieModule(releaseId1);
        ks.getRepository().removeKieModule(releaseId2);
    }

    @Test
    public void testScannerOnPomProjectSameKieSession() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "scanner-test", "1.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "scanner-test", "2.0");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployPomArtifact("org.kie", "scanner-master-test", "1.0", this.createMasterKPom("scanner-test", "1.0"));
        this.resetFileManager();
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, releaseId1, true, 2, 7, new ReleaseId[0]);
        repository.installArtifact(releaseId1, kJar1, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        KieContainer kieContainer = ks.newKieContainer(ks.newReleaseId("org.kie", "scanner-master-test", "LATEST"));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(false, ksession, 14);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        repository.deployPomArtifact("org.kie", "scanner-master-test", "2.0", this.createMasterKPom("scanner-test", "2.0"));
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, releaseId2, true, 3, 5, new ReleaseId[0]);
        repository.installArtifact(releaseId2, kJar2, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        scanner.scanNow();
        this.checkKSession(ksession, 10, 15);
        ks.getRepository().removeKieModule(releaseId1);
        ks.getRepository().removeKieModule(releaseId2);
    }

    private File createMasterKPom(String depArtifactId) throws IOException {
        return this.createMasterKPom(depArtifactId, "LATEST");
    }

    private File createMasterKPom(String depArtifactId, String depVersion) throws IOException {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>org.kie</groupId>\n  <artifactId>scanner-master-test</artifactId>\n  <version>1.0</version>\n  <packaging>pom</packaging>\n\n    <dependencies>\n      <dependency>\n        <groupId>org.kie</groupId>\n        <artifactId>" + depArtifactId + "</artifactId>\n        <version>" + depVersion + "</version>\n      </dependency>\n    </dependencies>\n</project>";
        File pomFile = this.fileManager.newFile("pom.xml");
        this.fileManager.write(pomFile, pom);
        return pomFile;
    }

    @Test
    public void testKieScannerOnClasspathContainerMustFail() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = ks.getKieClasspathContainer();
        try {
            KieScanner scanner = ks.newKieScanner(kieContainer);
            Assert.fail((String)"Creating a KieScanner from a KieClasspathContainer must fail");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testTypeAndRuleInDifferentKieModules() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId depId = ks.newReleaseId("org.kie", "test-types", "1.0");
        InternalKieModule kJar1 = this.createKieJarWithType(ks, depId);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(depId, kJar1, this.createKPom(this.fileManager, depId, new ReleaseId[0]));
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-rules", "1.0");
        InternalKieModule kieModule = this.createKieJarWithRules(ks, releaseId, depId);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, 15);
    }

    private InternalKieModule createKieJarWithType(KieServices ks, ReleaseId releaseId) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.write("src/main/resources/KBase1/r1.drl", "package org.kie.test\n" + this.getDRLWithType());
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    private InternalKieModule createKieJarWithRules(KieServices ks, ReleaseId releaseId, ReleaseId depId) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.write("src/main/resources/KBase1/r1.drl", "package org.kie.test\n" + this.getDRLWithRules(3, 5));
        kfs.writePomXML(this.getPom(releaseId, depId));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kieBuilder.buildAll();
        Assert.assertTrue((boolean)kieBuilder.getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    @Test
    public void testScannerOnPomRuleProject() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "scanner-test", "1.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "scanner-test", "2.0");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployPomArtifact("org.kie", "scanner-master-test", "1.0", this.createMasterKPom("scanner-test"));
        this.resetFileManager();
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId1, "rule1");
        repository.installArtifact(releaseId1, kJar1, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        KieContainer kieContainer = ks.newKieContainer(ks.newReleaseId("org.kie", "scanner-master-test", "LATEST"));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1");
        KieScanner scanner = ks.newKieScanner(kieContainer);
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId2, "rule2");
        repository.installArtifact(releaseId2, kJar2, this.createKPom(this.fileManager, releaseId2, new ReleaseId[0]));
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, "rule2");
        ks.getRepository().removeKieModule(releaseId1);
        ks.getRepository().removeKieModule(releaseId2);
    }

    @Test
    public void testMissingDependency() throws Exception {
        KieServices ks = KieServices.Factory.get();
        MavenRepository repository = MavenRepository.getMavenRepository();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0");
        ReleaseId missingDep = ks.newReleaseId("org.kie", "missing-dep", "1.0");
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(this.getPom(releaseId, missingDep));
        kfs.write("src/main/resources/KBase1/rule1.drl", this.createDRLWithTypeDeclaration(1, 1));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messages = kieBuilder.buildAll().getResults().getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertTrue((boolean)((Message)messages.get(0)).toString().contains("missing-dep"));
        ks.getRepository().removeKieModule(releaseId);
    }

    @Test
    public void testScanIncludedDependency() throws Exception {
        MavenRepository repository = MavenRepository.getMavenRepository();
        KieServices ks = KieServices.Factory.get();
        ReleaseId containerReleaseId = KieServices.Factory.get().newReleaseId("org.kie", "test-container", "1.0.0-SNAPSHOT");
        ReleaseId includedReleaseId = KieServices.Factory.get().newReleaseId("org.kie", "test-project", "1.0.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, includedReleaseId, "rule1");
        repository.installArtifact(includedReleaseId, kJar1, this.createKPom(this.fileManager, includedReleaseId, new ReleaseId[0]));
        this.resetFileManager();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("KBase2").addInclude("KBase1").newKieSessionModel("KSession2");
        kfs.writeKModuleXML(kproj.toXML());
        kfs.writePomXML(this.getPom(containerReleaseId, includedReleaseId));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        InternalKieModule containerKJar = (InternalKieModule)kieBuilder.getKieModule();
        repository.installArtifact(containerReleaseId, containerKJar, this.createKPom(this.fileManager, containerReleaseId, includedReleaseId));
        KieContainer kieContainer = ks.newKieContainer(containerReleaseId);
        KieSession ksession = kieContainer.newKieSession("KSession2");
        this.checkKSession(ksession, "rule1");
        KieScanner scanner = ks.newKieScanner(kieContainer);
        InternalKieModule kJar2 = this.createKieJar(ks, includedReleaseId, "rule2");
        repository.installArtifact(includedReleaseId, kJar2, this.createKPom(this.fileManager, includedReleaseId, new ReleaseId[0]));
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession2");
        this.checkKSession(ksession2, "rule2");
        ks.getRepository().removeKieModule(containerReleaseId);
        ks.getRepository().removeKieModule(includedReleaseId);
    }

    @Test
    @Ignore
    public void testScanIncludedAndIncludingDependency() throws Exception {
        MavenRepository repository = MavenRepository.getMavenRepository();
        KieServices ks = KieServices.Factory.get();
        ReleaseId containerReleaseId = KieServices.Factory.get().newReleaseId("org.kie", "test-container", "1.0.0-SNAPSHOT");
        ReleaseId includedReleaseId = KieServices.Factory.get().newReleaseId("org.kie", "test-project", "1.0.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, includedReleaseId, "rule1");
        repository.installArtifact(includedReleaseId, kJar1, this.createKPom(this.fileManager, includedReleaseId, new ReleaseId[0]));
        this.resetFileManager();
        InternalKieModule containerKJar = this.createIncludingKJar(containerReleaseId, includedReleaseId, "ruleX");
        repository.installArtifact(containerReleaseId, containerKJar, this.createKPom(this.fileManager, containerReleaseId, includedReleaseId));
        KieContainer kieContainer = ks.newKieContainer(containerReleaseId);
        KieSession ksession = kieContainer.newKieSession("KSession2");
        this.checkKSession(ksession, "rule1", "ruleX");
        this.resetFileManager();
        KieScanner scanner = ks.newKieScanner(kieContainer);
        InternalKieModule kJar2 = this.createKieJar(ks, includedReleaseId, "rule2");
        repository.installArtifact(includedReleaseId, kJar2, this.createKPom(this.fileManager, includedReleaseId, new ReleaseId[0]));
        this.resetFileManager();
        InternalKieModule containerKJar2 = this.createIncludingKJar(containerReleaseId, includedReleaseId, "ruleY");
        repository.installArtifact(containerReleaseId, containerKJar2, this.createKPom(this.fileManager, containerReleaseId, includedReleaseId));
        this.resetFileManager();
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession2");
        this.checkKSession(ksession2, "rule2", "ruleY");
        ks.getRepository().removeKieModule(containerReleaseId);
        ks.getRepository().removeKieModule(includedReleaseId);
    }

    private InternalKieModule createIncludingKJar(ReleaseId containerReleaseId, ReleaseId includedReleaseId, String rule) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        String file = "org/test/" + rule + ".drl";
        kfs.write("src/main/resources/KBase2/" + file, this.createDRL(rule));
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("KBase2").addInclude("KBase1").newKieSessionModel("KSession2");
        kfs.writeKModuleXML(kproj.toXML());
        kfs.writePomXML(this.getPom(containerReleaseId, includedReleaseId));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    @Test
    public void testKScannerWithGDRL() throws Exception {
        String rule1 = "import java.util.List;\nrule R when\n  $s : String()\nthen\n  list.add(\"Hello \" + $s);\nend";
        String rule2 = "import java.util.List;\nrule R when\n  $s : String()\nthen\n  list.add(\"Hi \" + $s);\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJarWithGDRL(ks, releaseId, rule1);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"Mario");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Hello Mario", list.get(0));
        list.clear();
        ksession.dispose();
        InternalKieModule kJar2 = this.createKieJarWithGDRL(ks, releaseId, rule2);
        repository.installArtifact(releaseId, kJar2, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieScanner scanner = ks.newKieScanner(kieContainer);
        scanner.scanNow();
        ksession = kieContainer.newKieSession("KSession1");
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"Mario");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Hi Mario", list.get(0));
        list.clear();
        ksession.dispose();
        ks.getRepository().removeKieModule(releaseId);
    }

    private InternalKieModule createKieJarWithGDRL(KieServices ks, ReleaseId releaseId, String rule) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        kfs.write("src/main/resources/rule.drl", rule);
        kfs.write("src/main/resources/global.gdrl", "global java.util.List list;");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    @Test
    public void testKJarContainingClassLoadedFromClassLoaderSameKBase() throws Exception {
        this.testKScannerWithKJarContainingClassLoadedFromClassLoader(false);
    }

    @Test
    public void testKJarContainingClassLoadedFromClassLoaderDifferentKBase() throws Exception {
        this.testKScannerWithKJarContainingClassLoadedFromClassLoader(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKScannerStartScanNow() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, "rule1", "rule2");
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1", "rule2");
        KieScanner scanner = ks.newKieScanner(kieContainer);
        scanner.start(100L);
        try {
            scanner.scanNow();
            InternalKieModule kJar2 = this.createKieJar(ks, releaseId, "rule2", "rule3");
            repository.installArtifact(releaseId, kJar2, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
            for (long timeSpent = 0L; timeSpent <= 5000L; timeSpent += 100L) {
                KieSession ksession2 = kieContainer.newKieSession("KSession1");
                if (this.producesResults(ksession2, "rule2", "rule3")) {
                    break;
                }
                Thread.sleep(100L);
            }
        }
        finally {
            scanner.stop();
            ks.getRepository().removeKieModule(releaseId);
        }
    }

    private void testKScannerWithKJarContainingClassLoadedFromClassLoader(boolean differentKbases) throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJarWithJavaClass(ks, releaseId, "KBase1", 7);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        ks.getRepository().removeKieModule(releaseId);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        Class<?> beanClass = kieContainer.getClassLoader().loadClass("org.kie.test.Bean");
        KieSession ksession = kieContainer.newKieSession("KSession1");
        Object bean = beanClass.getDeclaredConstructors()[0].newInstance(2);
        ksession.insert(bean);
        this.checkKSession(ksession, 14);
        InternalKieModule kJar2 = this.createKieJarWithJavaClass(ks, releaseId, differentKbases ? "KBase2" : "KBase1", 5);
        repository.installArtifact(releaseId, kJar2, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        ks.getRepository().removeKieModule(releaseId);
        Class<?> beanClass1 = Class.forName("org.kie.test.Bean", true, kieContainer.getClassLoader());
        kieContainer.updateToVersion(releaseId);
        beanClass = kieContainer.getClassLoader().loadClass("org.kie.test.Bean");
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        bean = beanClass.getDeclaredConstructors()[0].newInstance(3);
        ksession2.insert(bean);
        this.checkKSession(ksession2, 15);
        ks.getRepository().removeKieModule(releaseId);
    }

    private InternalKieModule createKieJarWithJavaClass(KieServices ks, ReleaseId releaseId, String kbaseName, int factor) throws IOException {
        String drl = "package org.kie.test.drl\nimport org.kie.test.Bean\nglobal java.util.List list\nrule R1\nwhen\n   $b : Bean( value > 0 )\nthen\n   list.add( $b.getValue() );\nend\n";
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false, kbaseName, "KSession1");
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        kfs.write("src/main/resources/KBase1/rule1.drl", drl).write("src/main/java/org/kie/test/Bean.java", this.createJavaSource(factor));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }
}

