/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.ReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.KieMavenRepository;

public class KieModuleBuilderTest
extends AbstractKieCiTest {
    private FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    @Test
    public void testKieModuleUsingPOMMissingKBaseDefinition() throws Exception {
        KieServices ks = KieServices.Factory.get();
        org.kie.api.builder.ReleaseId releaseId = ks.newReleaseId("org.kie", "metadata-test2", "1.0-SNAPSHOT");
        String pomText = this.getPom(releaseId, new org.kie.api.builder.ReleaseId[0]);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writePomXML(this.getPom(releaseId, new org.kie.api.builder.ReleaseId[0]));
        kfs.write("src/main/java/org/kie/test/Bean.java", this.createJavaSourceInPackage());
        KieBuilder kieBuilder1 = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder1.buildAll().getResults().getMessages().isEmpty());
        InternalKieModule kieModule = (InternalKieModule)kieBuilder1.getKieModule();
        KieMavenRepository.getKieMavenRepository().installArtifact((ReleaseId)releaseId, kieModule, pomFile);
        org.kie.api.builder.ReleaseId releaseId2 = ks.newReleaseId("org.kie", "metadata-test-using-pom", "1.0-SNAPSHOT");
        String pomText2 = this.getPom(releaseId2, releaseId);
        File pomFile2 = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId2, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile2);
            fos.write(pomText2.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kieFileSystem = kieServices.newKieFileSystem();
        FileInputStream is = new FileInputStream(pomFile2);
        KieModuleModel kproj2 = ks.newKieModuleModel();
        kieFileSystem.write("pom.xml", KieServices.Factory.get().getResources().newInputStreamResource((InputStream)is));
        kieFileSystem.writeKModuleXML(kproj2.toXML());
        kieFileSystem.write("src/main/resources/rule.drl", this.createDRLWithImport("rule1"));
        KieBuilder kieBuilder = kieServices.newKieBuilder(kieFileSystem);
        kieBuilder.buildAll();
        Assert.assertTrue((boolean)kieBuilder.getResults().getMessages().isEmpty());
    }

    private String createJavaSourceInPackage() {
        return "package org.kie.test;\npublic class Bean {\n   private int value;\n   public int getValue() {\n       return value;\n   }\n}";
    }

    protected String createDRLWithImport(String ruleName) {
        return "import org.kie.test.Bean\nrule " + ruleName + "\nwhen\nBean()\nthen\nend\n";
    }

    @Test
    public void testPomTypeDependencies() throws Exception {
        KieServices ks = KieServices.Factory.get();
        org.kie.api.builder.ReleaseId releaseIdNoDep = ks.newReleaseId("org.kie", "test-no-dep", "1.0-SNAPSHOT");
        org.kie.api.builder.ReleaseId releaseIdWithDep = ks.newReleaseId("org.kie", "test-with-dep", "1.0-SNAPSHOT");
        org.kie.api.builder.ReleaseId ejbReleaseId = ks.newReleaseId("org.jboss.as", "jboss-as-ejb-client-bom", "7.1.1.Final");
        org.kie.api.builder.ReleaseId jmsReleaseId = ks.newReleaseId("org.jboss.as", "jboss-as-jms-client-bom", "7.1.1.Final");
        String pom = this.getPomWithPomDependencies(releaseIdNoDep, ejbReleaseId, jmsReleaseId);
        File pomFile = this.fileManager.newFile("pom.xml");
        this.fileManager.write(pomFile, pom);
        InternalKieModule kJar1 = this.createKieJarWithPomDependencies(ks, releaseIdNoDep, pom);
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((ReleaseId)releaseIdNoDep, kJar1, pomFile);
        InternalKieModule kJar2 = this.createKieJarWithDependencies(ks, releaseIdWithDep, true, "rule1", releaseIdNoDep);
        KieContainer kieContainer2 = ks.newKieContainer(releaseIdWithDep);
        KieSession kieSession = kieContainer2.newKieSession();
    }

    private InternalKieModule createKieJarWithPomDependencies(KieServices ks, org.kie.api.builder.ReleaseId releaseId, String pom) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(pom);
        kfs.write("src/main/java/org/kie/test/Bean.java", this.createJavaSource(3));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    private String getPomWithPomDependencies(org.kie.api.builder.ReleaseId releaseId, org.kie.api.builder.ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (org.kie.api.builder.ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "  <type>pom</type>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    @Override
    protected String createDRL(String ruleName) {
        return "import org.kie.test.Bean\nrule " + ruleName + "\nwhen\n  $b: Bean()\nthen\n  System.out.println($b);end\n";
    }
}

