/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.embedder;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.appformer.maven.support.ReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.eclipse.aether.repository.RemoteRepository;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.KieMavenRepository;

public class MavenDeployTest
extends AbstractKieCiTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeploy() throws IOException {
        KieServices ks = KieServices.Factory.get();
        org.kie.api.builder.ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test-deploy", "1.0-SNAPSHOT");
        Path m2Folder = Files.createTempDirectory("temp-m2", new FileAttribute[0]);
        Path settingsXmlPath = MavenDeployTest.generateSettingsXml(m2Folder);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            MavenSettings.reinitSettings();
            InternalKieModule kJar1 = this.createKieJar(ks, releaseId, "rule1", "rule2");
            KieContainer kieContainer = ks.newKieContainer(releaseId);
            KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
            RemoteRepository remote = MavenDeployTest.createRemoteRepository(m2Folder);
            repository.deployArtifact(remote, (ReleaseId)releaseId, kJar1, this.createKPom(m2Folder, releaseId).toFile());
            KieSession ksession = kieContainer.newKieSession("KSession1");
            this.checkKSession(ksession, "rule1", "rule2");
            InternalKieModule kJar2 = this.createKieJar(ks, releaseId, "rule2", "rule3");
            repository.deployArtifact(remote, (ReleaseId)releaseId, kJar2, this.createKPom(m2Folder, releaseId).toFile());
            KieScanner scanner = ks.newKieScanner(kieContainer);
            scanner.scanNow();
            KieSession ksession2 = kieContainer.newKieSession("KSession1");
            this.checkKSession(ksession2, "rule2", "rule3");
            ks.getRepository().removeKieModule(releaseId);
        }
        finally {
            if (oldSettingsXmlPath == null) {
                System.clearProperty("kie.maven.settings.custom");
            } else {
                System.setProperty("kie.maven.settings.custom", oldSettingsXmlPath);
            }
            MavenSettings.reinitSettings();
        }
    }

    private static Path generateSettingsXml(Path m2Folder) throws IOException {
        String settingsXml = "<settings xmlns=\"http://maven.apache.org/SETTINGS/1.0.0\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/SETTINGS/1.0.0\n                          http://maven.apache.org/xsd/settings-1.0.0.xsd\">\n  <profiles>\n    <profile>\n      <id>repos</id>\n      <activation>\n        <activeByDefault>true</activeByDefault>\n      </activation>\n      <repositories>\n        <repository>\n          <id>myTestRepo</id>\n          <name>My Test Repo</name>\n          <url>" + m2Folder.toUri().toURL().toExternalForm() + "</url>\n          <releases><enabled>true</enabled></releases>\n          <snapshots><enabled>true</enabled></snapshots>\n        </repository>\n    </repositories>\n    </profile>\n  </profiles>\n</settings>\n";
        Path settingsXmlPath = Files.createTempFile(m2Folder, "settings", ".xml", new FileAttribute[0]);
        Files.write(settingsXmlPath, settingsXml.getBytes(), new OpenOption[0]);
        return settingsXmlPath;
    }

    private static RemoteRepository createRemoteRepository(Path m2Folder) throws MalformedURLException {
        String localRepositoryUrl = m2Folder.toUri().toURL().toExternalForm();
        return new RemoteRepository.Builder("myTestRepo", "default", localRepositoryUrl).build();
    }

    protected Path createKPom(Path m2Folder, org.kie.api.builder.ReleaseId releaseId) throws IOException {
        Path pomXmlPath = Files.createTempFile(m2Folder, "pom", ".xml", new FileAttribute[0]);
        Files.write(pomXmlPath, this.getPom(releaseId, new org.kie.api.builder.ReleaseId[0]).getBytes(), new OpenOption[0]);
        return pomXmlPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKScannerWithDeployUsingDistributionManagement() throws IOException {
        KieServices ks = KieServices.Factory.get();
        org.kie.api.builder.ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test-deploy-dist", "1.0-SNAPSHOT");
        Path m2Folder = Files.createTempDirectory("temp-m2-dist", new FileAttribute[0]);
        Path settingsXmlPath = MavenDeployTest.generateSettingsXml(m2Folder);
        String oldSettingsXmlPath = System.getProperty("kie.maven.settings.custom");
        try {
            System.setProperty("kie.maven.settings.custom", settingsXmlPath.toString());
            MavenSettings.reinitSettings();
            InternalKieModule kJar1 = this.createKieJar(ks, releaseId, "rule1", "rule2");
            KieContainer kieContainer = ks.newKieContainer(releaseId);
            KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
            repository.deployArtifact((ReleaseId)releaseId, kJar1, this.createKPomWithDistributionManagement(m2Folder, releaseId).toFile());
            KieSession ksession = kieContainer.newKieSession("KSession1");
            this.checkKSession(ksession, "rule1", "rule2");
            InternalKieModule kJar2 = this.createKieJar(ks, releaseId, "rule2", "rule3");
            repository.deployArtifact((ReleaseId)releaseId, kJar2, this.createKPomWithDistributionManagement(m2Folder, releaseId).toFile());
            KieScanner scanner = ks.newKieScanner(kieContainer);
            scanner.scanNow();
            KieSession ksession2 = kieContainer.newKieSession("KSession1");
            this.checkKSession(ksession2, "rule2", "rule3");
            ks.getRepository().removeKieModule(releaseId);
        }
        finally {
            if (oldSettingsXmlPath == null) {
                System.clearProperty("kie.maven.settings.custom");
            } else {
                System.setProperty("kie.maven.settings.custom", oldSettingsXmlPath);
            }
            MavenSettings.reinitSettings();
        }
    }

    protected Path createKPomWithDistributionManagement(Path m2Folder, org.kie.api.builder.ReleaseId releaseId) throws IOException {
        String localRepositoryUrl = m2Folder.toUri().toURL().toExternalForm();
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n   <distributionManagement>\n     <repository>\n       <id>myTestRepo</id>\n       <name>Releases Repository</name>\n       <url>" + localRepositoryUrl + "</url>\n    </repository>\n    <snapshotRepository>\n      <id>myTestRepo-snapshots</id>\n      <name>Snapshot Repository</name>\n       <url>" + localRepositoryUrl + "</url>\n    </snapshotRepository>\n  </distributionManagement></project>";
        Path pomXmlPath = Files.createTempFile(m2Folder, "pom", ".xml", new FileAttribute[0]);
        Files.write(pomXmlPath, pom.getBytes(), new OpenOption[0]);
        return pomXmlPath;
    }
}

