/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.Aether;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.ReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieMavenRepository
extends MavenRepository {
    private static final Logger log = LoggerFactory.getLogger(KieMavenRepository.class);
    public static KieMavenRepository defaultMavenRepository;

    protected KieMavenRepository(Aether aether) {
        super(aether);
    }

    public static synchronized KieMavenRepository getKieMavenRepository() {
        if (defaultMavenRepository == null) {
            Aether defaultAether = Aether.getAether();
            defaultMavenRepository = new KieMavenRepository(defaultAether);
        }
        return defaultMavenRepository;
    }

    public static KieMavenRepository getKieMavenRepository(MavenProject mavenProject) {
        return new KieMavenRepository(new Aether(mavenProject));
    }

    public void deployArtifact(ReleaseId releaseId, InternalKieModule kieModule, File pomfile) {
        RemoteRepository repository = this.getRemoteRepositoryFromDistributionManagement(pomfile);
        if (repository == null) {
            log.warn("No Distribution Management configured: unknown repository");
            return;
        }
        this.deployArtifact(repository, releaseId, kieModule, pomfile);
    }

    public void deployArtifact(RemoteRepository repository, ReleaseId releaseId, InternalKieModule kieModule, File pomfile) {
        File jarFile = this.bytesToFile(releaseId, kieModule.getBytes(), ".jar");
        this.deployArtifact(repository, releaseId, jarFile, pomfile);
    }

    public void installArtifact(ReleaseId releaseId, InternalKieModule kieModule, File pomfile) {
        File jarFile = this.bytesToFile(releaseId, kieModule.getBytes(), ".jar");
        this.installArtifact(releaseId, jarFile, pomfile);
    }
}

