/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.builder.helper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.util.IoUtils;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.helper.FluentKieModuleDeploymentHelper;
import org.kie.api.builder.helper.KieModuleDeploymentConfig;
import org.kie.api.builder.helper.SingleKieModuleDeploymentHelper;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.maven.integration.MavenRepository;
import org.kie.scanner.KieMavenRepository;
import org.kie.util.maven.support.ReleaseIdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KieModuleDeploymentHelperImpl
extends FluentKieModuleDeploymentHelper
implements SingleKieModuleDeploymentHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieModuleDeploymentHelperImpl.class);
    private KieModuleDeploymentConfig config = new KieModuleDeploymentConfig();

    KieModuleDeploymentHelperImpl() {
    }

    @Override
    public FluentKieModuleDeploymentHelper setGroupId(String groupId) {
        KieModuleDeploymentHelperImpl.assertNotNull(groupId, "groupId");
        this.config.setGroupId(groupId);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setArtifactId(String artifactId) {
        KieModuleDeploymentHelperImpl.assertNotNull(artifactId, "artifactId");
        this.config.setArtifactId(artifactId);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setVersion(String version) {
        KieModuleDeploymentHelperImpl.assertNotNull(version, "version");
        this.config.setVersion(version);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setKBaseName(String kbaseName) {
        KieModuleDeploymentHelperImpl.assertNotNull(kbaseName, "kbase name");
        this.config.setKbaseName(kbaseName);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setKieSessionname(String ksessionName) {
        KieModuleDeploymentHelperImpl.assertNotNull(ksessionName, "ksession name");
        this.config.setKsessionName(ksessionName);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setResourceFilePaths(List<String> resourceFilePaths) {
        KieModuleDeploymentHelperImpl.assertNotNull(resourceFilePaths, "resourceFilePaths");
        this.config.resourceFilePaths.addAll(resourceFilePaths);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper addResourceFilePath(String ... resourceFilePath) {
        KieModuleDeploymentHelperImpl.assertNotNull(resourceFilePath, "resourceFilePath");
        for (int i = 0; i < resourceFilePath.length; ++i) {
            KieModuleDeploymentHelperImpl.assertNotNull(resourceFilePath[i], "resourceFilePath[" + i + "]");
            this.config.resourceFilePaths.add(resourceFilePath[i]);
        }
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setClasses(List<Class<?>> classesForKjar) {
        KieModuleDeploymentHelperImpl.assertNotNull(classesForKjar, "classesForKjar");
        this.config.classes.addAll(classesForKjar);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper addClass(Class<?> ... classForKjar) {
        KieModuleDeploymentHelperImpl.assertNotNull(classForKjar, "classForKjar");
        for (int i = 0; i < classForKjar.length; ++i) {
            KieModuleDeploymentHelperImpl.assertNotNull(classForKjar[i], "classForKjar[" + i + "]");
            this.config.classes.add(classForKjar[i]);
        }
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setDependencies(List<String> dependencies) {
        KieModuleDeploymentHelperImpl.assertNotNull(dependencies, "dependencies");
        this.config.dependencies.addAll(dependencies);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper addDependencies(String ... dependency) {
        KieModuleDeploymentHelperImpl.assertNotNull(dependency, "dependency");
        for (int i = 0; i < dependency.length; ++i) {
            KieModuleDeploymentHelperImpl.assertNotNull(dependency[i], "dependency[" + i + "]");
            this.config.dependencies.add(dependency[i]);
        }
        return this;
    }

    @Override
    public KieModuleModel getKieModuleModel() {
        return this.config.getKieProject();
    }

    @Override
    public FluentKieModuleDeploymentHelper resetHelper() {
        this.config = new KieModuleDeploymentConfig();
        return this;
    }

    @Override
    public KieModule createKieJar() {
        this.config.checkComplete();
        return this.internalCreateKieJar(this.config.getReleaseId(), this.config.getKbaseName(), this.config.getKsessionName(), this.config.resourceFilePaths, this.config.classes, this.config.dependencies);
    }

    @Override
    public void createKieJarAndDeployToMaven() {
        this.config.checkComplete();
        this.internalCreateAndDeployKjarToMaven(this.config.getReleaseId(), this.config.getKbaseName(), this.config.getKsessionName(), this.config.resourceFilePaths, this.config.classes, this.config.dependencies);
    }

    private static void assertNotNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException("Null " + name + " arguments are not accepted!");
        }
    }

    @Override
    public KieModule createKieJar(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> resourceFilePaths) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        return this.internalCreateKieJar((ReleaseId)releaseId, kbaseName, ksessionName, resourceFilePaths, null, null);
    }

    @Override
    public KieModule createKieJar(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> bpmnFilePaths, List<Class<?>> classes) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        return this.internalCreateKieJar((ReleaseId)releaseId, kbaseName, ksessionName, bpmnFilePaths, classes, null);
    }

    @Override
    public KieModule createKieJar(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> bpmnFilePaths, List<Class<?>> classes, List<String> dependencies) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        return this.internalCreateKieJar((ReleaseId)releaseId, kbaseName, ksessionName, bpmnFilePaths, classes, dependencies);
    }

    @Override
    public void createKieJarAndDeployToMaven(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> resourceFilePaths) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        this.internalCreateAndDeployKjarToMaven((ReleaseId)releaseId, kbaseName, ksessionName, resourceFilePaths, null, null);
    }

    @Override
    public void createKieJarAndDeployToMaven(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> resourceFilePaths, List<Class<?>> classesForKjar) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        this.internalCreateAndDeployKjarToMaven((ReleaseId)releaseId, kbaseName, ksessionName, resourceFilePaths, classesForKjar, null);
    }

    @Override
    public void createKieJarAndDeployToMaven(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> resourceFilePaths, List<Class<?>> classesForKjar, List<String> dependencies) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        this.internalCreateAndDeployKjarToMaven((ReleaseId)releaseId, kbaseName, ksessionName, resourceFilePaths, classesForKjar, dependencies);
    }

    private synchronized void internalCreateAndDeployKjarToMaven(ReleaseId releaseId, String kbaseName, String ksessionName, List<String> resourceFilePaths, List<Class<?>> classes, List<String> dependencies) {
        InternalKieModule kjar = (InternalKieModule)this.internalCreateKieJar(releaseId, kbaseName, ksessionName, resourceFilePaths, classes, dependencies);
        String pomFileName = MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom";
        File pomFile = new File(System.getProperty("java.io.tmpdir"), pomFileName);
        try (FileOutputStream fos = new FileOutputStream(pomFile);){
            fos.write(this.config.pomText.getBytes(IoUtils.UTF8_CHARSET));
            fos.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to write pom.xml to temporary file : " + ioe.getMessage(), ioe);
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact(releaseId, kjar, pomFile);
    }

    private synchronized KieModule internalCreateKieJar(ReleaseId releaseId, String kbaseName, String ksessionName, List<String> resourceFilePaths, List<Class<?>> classes, List<String> dependencies) {
        ReleaseId[] releaseIds = new ReleaseId[]{};
        if (dependencies != null && dependencies.size() > 0) {
            ArrayList<ReleaseIdImpl> depReleaseIds = new ArrayList<ReleaseIdImpl>();
            for (String string : dependencies) {
                String[] gav = string.split(":");
                if (gav.length != 3) {
                    throw new IllegalArgumentException("Dependendency id '" + string + "' does not conform to the format <groupId>:<artifactId>:<version> (Classifiers are not accepted).");
                }
                depReleaseIds.add(new ReleaseIdImpl(gav[0], gav[1], gav[2]));
            }
            releaseIds = depReleaseIds.toArray(new ReleaseId[depReleaseIds.size()]);
        }
        this.config.pomText = KieModuleDeploymentHelperImpl.getPomText(releaseId, releaseIds);
        KieFileSystem kfs = this.createKieFileSystemWithKProject();
        kfs.writePomXML(this.config.pomText);
        List<KJarResource> resourceFiles = KieModuleDeploymentHelperImpl.loadResources(resourceFilePaths);
        for (KJarResource resource : resourceFiles) {
            kfs.write("src/main/resources/" + kbaseName + "/" + resource.name, resource.content);
        }
        if (classes != null) {
            for (Class<?> userClass : classes) {
                KieModuleDeploymentHelperImpl.addClass(userClass, kfs);
            }
        }
        KieBuilder kieBuilder = this.config.getKieServicesInstance().newKieBuilder(kfs);
        int buildMsgs = 0;
        for (Message buildMsg : kieBuilder.buildAll().getResults().getMessages()) {
            System.out.println(buildMsg.getPath() + " : " + buildMsg.getText());
            ++buildMsgs;
        }
        if (buildMsgs > 0) {
            throw new RuntimeException("Unable to build KieModule, see the " + buildMsgs + " messages above.");
        }
        return kieBuilder.getKieModule();
    }

    private KieFileSystem createKieFileSystemWithKProject() {
        KieModuleModel kproj = this.config.getKieProject();
        KieFileSystem kfs = this.config.getKieServicesInstance().newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    private static String getPomText(ReleaseId releaseId, ReleaseId ... dependencies) {
        StringBuilder pom = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n");
        if (dependencies != null && dependencies.length > 0) {
            pom.append("<dependencies>\n");
            for (ReleaseId dep : dependencies) {
                pom.append("<dependency>\n");
                pom.append("  <groupId>").append(dep.getGroupId()).append("</groupId>\n");
                pom.append("  <artifactId>").append(dep.getArtifactId()).append("</artifactId>\n");
                pom.append("  <version>").append(dep.getVersion()).append("</version>\n");
                pom.append("</dependency>\n");
            }
            pom.append("</dependencies>\n");
        }
        pom.append("</project>");
        return pom.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<KJarResource> internalLoadResources(String path, boolean fromDir) throws Exception {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        ArrayList<KJarResource> output = new ArrayList<KJarResource>();
        URL url = KieModuleDeploymentHelperImpl.class.getResource((String)path);
        if (fromDir) {
            int jarPathIndex;
            if (url == null) {
                File folder = new File((String)path);
                if (!folder.exists()) throw new IllegalArgumentException("Directory + '" + (String)path + "' does not exist.");
                for (File folderFile : folder.listFiles()) {
                    if (folderFile.isDirectory()) continue;
                    String content = KieModuleDeploymentHelperImpl.convertFileToString(new FileInputStream(folderFile), true);
                    output.add(new KJarResource(folderFile.getName(), content));
                }
                return output;
            }
            if ("file".equals(url.getProtocol())) {
                File folder = new File(url.toURI());
                if (!folder.isDirectory()) throw new IllegalStateException("'" + (String)path + "' is not an existing directory.");
                for (File folderFile : folder.listFiles()) {
                    if (folderFile.getName().endsWith(".class") || folderFile.isDirectory()) continue;
                    String content = KieModuleDeploymentHelperImpl.convertFileToString(new FileInputStream(folderFile), true);
                    output.add(new KJarResource(folderFile.getName(), content));
                }
                return output;
            }
            if (!"jar".equals(url.getProtocol())) throw new IllegalArgumentException("Unable to find resource directory '" + (String)path + "'");
            String urlString = url.toExternalForm();
            String resourcePath = urlString.substring((jarPathIndex = urlString.lastIndexOf(".jar!") + 4) + 1);
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            int depth = resourcePath.split("/").length + 1;
            String jarUrlString = urlString.substring("jar:".length(), jarPathIndex);
            url = new URL(jarUrlString);
            ZipInputStream zip = new ZipInputStream(url.openStream());
            try {
                ZipEntry ze = zip.getNextEntry();
                while (ze != null) {
                    String name = ze.getName();
                    if (name.startsWith(resourcePath) && !name.endsWith("/") && name.split("/").length == depth) {
                        String shortName = name.substring(name.lastIndexOf("/") + 1);
                        String content = KieModuleDeploymentHelperImpl.convertFileToString(zip, false);
                        output.add(new KJarResource(shortName, content));
                    }
                    ze = zip.getNextEntry();
                }
                return output;
            }
            finally {
                try {
                    zip.close();
                }
                catch (Exception exception) {}
            }
        }
        InputStream is = KieModuleDeploymentHelperImpl.class.getResourceAsStream((String)path);
        if (is == null) {
            is = new FileInputStream(new File((String)path));
        }
        String content = KieModuleDeploymentHelperImpl.convertFileToString(is, true);
        String name = ((String)path).substring(((String)path).lastIndexOf("/") + 1);
        output.add(new KJarResource(name, content));
        return output;
    }

    private static List<KJarResource> loadResources(List<String> resourceFilePaths) {
        ArrayList<KJarResource> kjarResources = new ArrayList<KJarResource>();
        for (String filePath : resourceFilePaths) {
            if (filePath.endsWith("/")) {
                try {
                    kjarResources.addAll(KieModuleDeploymentHelperImpl.internalLoadResources(filePath, true));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to load resources from " + filePath + ": " + e.getMessage(), e);
                }
            }
            try {
                kjarResources.addAll(KieModuleDeploymentHelperImpl.internalLoadResources(filePath, false));
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException("No file found at '" + filePath + "' -- if it's a directory, please add a / to the end of the path.");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load resource from '" + filePath + "'", e);
            }
        }
        return kjarResources;
    }

    private static String convertFileToString(InputStream in, boolean closeInput) {
        try {
            return new String(IoUtils.readBytesFromInputStream((InputStream)in, (boolean)closeInput), IoUtils.UTF8_CHARSET);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addClass(Class<?> userClass, KieFileSystem kfs) {
        String classSimpleName = userClass.getSimpleName();
        URL classFileUrl = userClass.getResource(classSimpleName + ".class");
        if (classFileUrl == null) {
            throw new RuntimeException("Class " + userClass.getCanonicalName() + " can not be found on the classpath.");
        }
        byte[] classByteCode = null;
        if ("file".equalsIgnoreCase(classFileUrl.getProtocol())) {
            File classFile = new File(classFileUrl.getPath());
            if (!classFile.exists()) {
                throw new RuntimeException("Unable to find path for class " + userClass.getCanonicalName() + " that should be here: " + classFileUrl.toExternalForm());
            }
            try {
                classByteCode = KieModuleDeploymentHelperImpl.readStream(new FileInputStream(classFile));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read in " + classFile.getAbsolutePath(), e);
            }
            if (classByteCode.length == 0) {
                throw new RuntimeException("No bytes retrieved from " + classFile.getAbsolutePath());
            }
        } else if ("jar".equalsIgnoreCase(classFileUrl.getProtocol())) {
            String path = classFileUrl.getPath();
            int bangIndex = path.indexOf(33);
            String jarPath = path.substring("file:".length(), bangIndex);
            String classPath = path.substring(bangIndex + 2);
            try (ZipFile zipFile = new ZipFile(new File(jarPath));){
                ZipEntry entry = zipFile.getEntry(classPath);
                InputStream zipStream = zipFile.getInputStream(entry);
                classByteCode = KieModuleDeploymentHelperImpl.readStream(zipStream);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read from " + jarPath, e);
            }
        }
        String pkgFolder = userClass.getPackage().toString();
        pkgFolder = pkgFolder.replace("package ", "");
        pkgFolder = pkgFolder.replaceAll(",.+$", "");
        String classFilePath = (pkgFolder = pkgFolder.replaceAll("\\.", "/")) + "/" + classSimpleName + ".class";
        if (classFilePath.contains(" ")) {
            throw new RuntimeException("Invalid class name ('" + classFilePath + "'), contact the developers.");
        }
        kfs.write(classFilePath, classByteCode);
    }

    private static byte[] readStream(InputStream ios) throws Exception {
        try {
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] buffer = new byte[4096];
                int read = 0;
                while ((read = ios.read(buffer)) != -1) {
                    baos.write(buffer, 0, read);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        finally {
            try {
                if (ios != null) {
                    ios.close();
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    static class KJarResource {
        public String name;
        public String content;

        public KJarResource(String name, String content) {
            this.content = content;
            this.name = name;
        }
    }
}

