/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.config.cli.command.CliCommand;
import org.kie.config.cli.command.impl.AddDeploymentConfigCliCommand;
import org.kie.config.cli.command.impl.AddRepositoryToGroupCliCommand;
import org.kie.config.cli.command.impl.AddRoleToGroupCliCommand;
import org.kie.config.cli.command.impl.AddRoleToRepositoryCliCommand;
import org.kie.config.cli.command.impl.CreateGroupCliCommand;
import org.kie.config.cli.command.impl.CreateRepositoryCliCommand;
import org.kie.config.cli.command.impl.ExitCliCommand;
import org.kie.config.cli.command.impl.HelpCliCommand;
import org.kie.config.cli.command.impl.ListDeploymentsCliCommand;
import org.kie.config.cli.command.impl.ListGroupsCliCommand;
import org.kie.config.cli.command.impl.ListRepositoriesCliCommand;
import org.kie.config.cli.command.impl.RemoveDeploymentConfigCliCommand;
import org.kie.config.cli.command.impl.RemoveGroupCliCommand;
import org.kie.config.cli.command.impl.RemoveRepositoryCliCommand;
import org.kie.config.cli.command.impl.RemoveRepositoryFromGroupCliCommand;
import org.kie.config.cli.command.impl.RemoveRoleFromGroupCliCommand;
import org.kie.config.cli.command.impl.RemoveRoleFromRepositoryCliCommand;

public class CliCommandRegistry {
    private static CliCommandRegistry instance;
    private Map<String, CliCommand> commands = new HashMap<String, CliCommand>();

    private CliCommandRegistry() {
        this.commands.put("exit", new ExitCliCommand());
        this.commands.put("help", new HelpCliCommand());
        this.commands.put("list-deployment", new ListDeploymentsCliCommand());
        this.commands.put("list-repo", new ListRepositoriesCliCommand());
        this.commands.put("list-group", new ListGroupsCliCommand());
        this.commands.put("create-group", new CreateGroupCliCommand());
        this.commands.put("remove-group", new RemoveGroupCliCommand());
        this.commands.put("add-deployment", new AddDeploymentConfigCliCommand());
        this.commands.put("remove-deployment", new RemoveDeploymentConfigCliCommand());
        this.commands.put("create-repo", new CreateRepositoryCliCommand());
        this.commands.put("remove-repo", new RemoveRepositoryCliCommand());
        this.commands.put("add-repo-group", new AddRepositoryToGroupCliCommand());
        this.commands.put("remove-repo-group", new RemoveRepositoryFromGroupCliCommand());
        this.commands.put("add-role-repo", new AddRoleToRepositoryCliCommand());
        this.commands.put("remove-role-repo", new RemoveRoleFromRepositoryCliCommand());
        this.commands.put("add-role-group", new AddRoleToGroupCliCommand());
        this.commands.put("remove-role-group", new RemoveRoleFromGroupCliCommand());
    }

    public static CliCommandRegistry get() {
        if (instance == null) {
            instance = new CliCommandRegistry();
        }
        return instance;
    }

    public CliCommand getCommand(String name) {
        return this.commands.get(name);
    }

    public List<String> findMatching(String commandName) {
        ArrayList<String> matched = new ArrayList<String>();
        for (String command : this.commands.keySet()) {
            if (!command.startsWith(commandName)) continue;
            matched.add(command);
        }
        return matched;
    }
}

