/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.kie.commons.io.IOService;
import org.kie.commons.io.impl.IOServiceDotFileImpl;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.repositories.SystemRepository;
import org.uberfire.security.Resource;
import org.uberfire.security.Role;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.AuthorizationException;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.RuntimeResource;
import org.uberfire.security.server.cdi.SecurityFactory;

@ApplicationScoped
public class EnvironmentProvider {
    private final IOService ioService = new IOServiceDotFileImpl();
    public static final Role ADMIN_ROLE = new Role(){

        public String getName() {
            return "ADMIN";
        }
    };

    @PostConstruct
    public void setup() {
        SecurityFactory.setAuthzManager((AuthorizationManager)new AuthorizationManager(){

            public boolean supports(Resource resource) {
                return resource instanceof RuntimeResource;
            }

            public boolean authorize(Resource resource, Subject subject) throws AuthorizationException {
                return subject.getRoles().contains(ADMIN_ROLE);
            }
        });
    }

    @Produces
    @Named(value="system")
    public Repository systemRepository() {
        return SystemRepository.SYSTEM_REPO;
    }

    @Produces
    @Named(value="ioStrategy")
    public IOService ioService() {
        return this.ioService;
    }
}

