/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Scanner;
import org.kie.config.cli.CliContext;
import org.kie.config.cli.command.CliCommand;
import org.kie.config.cli.command.CliCommandRegistry;
import org.kie.config.cli.command.impl.CloneGitRepositoryCliCommand;

public class CmdMain {
    public static void main(String[] args) {
        String niogitPath;
        System.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        System.setProperty("java.awt.headless", "true");
        Scanner scanner = new Scanner(new InputStreamReader(System.in));
        System.out.println("********************************************************\n");
        System.out.println("************* Welcome to Kie config CLI ****************\n");
        System.out.println("********************************************************\n");
        CliContext context = null;
        if (args != null && args.length > 0 && "offline".equalsIgnoreCase(args[0])) {
            System.out.println(">>Please specify location of the parent folder of .niogit");
            niogitPath = scanner.nextLine();
            CmdMain.exitIfRequested(niogitPath);
            boolean foundFolder = false;
            while (!foundFolder) {
                File niogitParent = new File(niogitPath);
                if (!(niogitParent.exists() && niogitParent.isDirectory() && CmdMain.isNiogitDir(niogitParent))) {
                    System.out.println(".niogit folder not found: Try again[1] or continue to create new one[2]?:");
                    String answer = scanner.nextLine();
                    if ("2".equalsIgnoreCase(answer)) {
                        System.setProperty("org.uberfire.nio.git.dir", niogitPath);
                        foundFolder = true;
                        continue;
                    }
                    System.out.println(">>Please specify location of the parent folder of .niogit");
                    niogitPath = scanner.nextLine();
                    CmdMain.exitIfRequested(niogitPath);
                    continue;
                }
                System.setProperty("org.uberfire.nio.git.dir", niogitPath);
                foundFolder = true;
            }
            context = CliContext.buildContext(scanner);
        } else {
            niogitPath = System.getProperty("java.io.tmpdir") + File.separator + "kie-tmp-repo";
            new File(niogitPath).mkdir();
            System.setProperty("org.uberfire.nio.git.dir", niogitPath);
            context = CliContext.buildContext(scanner);
            context.addParameter("tmp-dir", niogitPath);
            CloneGitRepositoryCliCommand command = new CloneGitRepositoryCliCommand();
            command.execute(context);
        }
        System.out.println(">>Please enter command (type help to see available commands): ");
        while (scanner.hasNext()) {
            String commandName = scanner.nextLine();
            CliCommand command = CliCommandRegistry.get().getCommand(commandName);
            if (command != null) {
                try {
                    String result = command.execute(context);
                    System.out.println("Result:");
                    System.out.println((Object)result);
                    System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>");
                }
                catch (Throwable e) {
                    System.err.println("Unhandled exception caught while executing command " + commandName + " error: " + e.getMessage());
                    e.printStackTrace();
                }
                System.out.println(">>Please enter command (type help to see available commands): ");
                continue;
            }
            List<String> matches = CliCommandRegistry.get().findMatching(commandName);
            if (matches.isEmpty()) {
                System.out.println("No command found for '" + commandName + "'");
                continue;
            }
            System.out.println("Command '" + commandName + "' not found, did you mean:");
            for (String cmd : matches) {
                System.out.println("\t" + cmd);
            }
        }
    }

    private static void exitIfRequested(String input) {
        if ("exit".equalsIgnoreCase(input)) {
            System.exit(0);
        }
    }

    private static boolean isNiogitDir(File parentFolder) {
        String[] matchingFiles = parentFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(".niogit");
            }
        });
        return matchingFiles.length == 1;
    }
}

