/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.command.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.weld.environment.se.WeldContainer;
import org.kie.config.cli.CliContext;
import org.kie.config.cli.command.CliCommand;
import org.kie.config.cli.support.InputReader;

public class CreateOrganizationalUnitCliCommand
implements CliCommand {
    @Override
    public String getName() {
        return "create-org-unit";
    }

    @Override
    public String execute(CliContext context) {
        StringBuffer result = new StringBuffer();
        WeldContainer container = context.getContainer();
        OrganizationalUnitService organizationalUnitService = (OrganizationalUnitService)container.instance().select(OrganizationalUnitService.class, new Annotation[0]).get();
        RepositoryService repositoryService = (RepositoryService)container.instance().select(RepositoryService.class, new Annotation[0]).get();
        InputReader input = context.getInput();
        System.out.print(">>Organizational Unit name:");
        String name = input.nextLine();
        System.out.print(">>Organizational Unit owner:");
        String owner = input.nextLine();
        System.out.print(">>Default Group Id for this Organizational Unit:");
        String defaultGroupId = input.nextLine();
        System.out.print(">>Repositories (comma separated list):");
        String repos = input.nextLine();
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (repos != null && repos.trim().length() > 0) {
            String[] repoAliases;
            for (String alias : repoAliases = repos.split(",")) {
                Repository repo = repositoryService.getRepository(alias);
                if (repo != null) {
                    repositories.add(repo);
                    continue;
                }
                System.out.println("WARN: Repository with alias " + alias + " does not exists and will be skipped");
            }
        }
        OrganizationalUnit organizationalUnit = organizationalUnitService.createOrganizationalUnit(name, owner, defaultGroupId, repositories);
        result.append("Organizational Unit " + organizationalUnit.getName() + " successfully created");
        return result.toString();
    }
}

