/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.UnauthorizedException;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.kie.config.cli.CliIdentity;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.paging.PageResponse;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.RuntimeResource;
import org.uberfire.security.impl.authz.RuntimeAuthorizationManager;

@ApplicationScoped
public class EnvironmentProvider {
    private final IOService ioService = new IOServiceDotFileImpl();
    public static final Role ADMIN_ROLE = new Role(){

        public String getName() {
            return "admin";
        }
    };
    @Inject
    CliIdentity cliIdentity;

    @Produces
    @Named(value="ioStrategy")
    public IOService ioService() {
        return this.ioService;
    }

    @Produces
    @Alternative
    public SessionInfo getSessionInfo() {
        CliIdentity identity = new CliIdentity();
        return new SessionInfoImpl(identity.getIdentifier(), (User)identity);
    }

    @Produces
    public AuthorizationManager getAuthManager() {
        return new RuntimeAuthorizationManager(){

            public boolean supports(Resource resource) {
                return resource instanceof RuntimeResource;
            }

            public boolean authorize(Resource resource, User subject) throws UnauthorizedException {
                return subject.getRoles().contains(ADMIN_ROLE);
            }
        };
    }

    @Produces
    public RefactoringQueryService getRefactoringQueryService() {
        return new RefactoringQueryService(){

            public Set<String> getQueries() {
                return Collections.emptySet();
            }

            public Set<IndexTerm> getTerms(String queryName) {
                return Collections.emptySet();
            }

            public PageResponse<RefactoringPageRow> query(RefactoringPageRequest request) {
                return new PageResponse();
            }

            public List<RefactoringPageRow> query(String queryName, Set<ValueIndexTerm> queryTerms, boolean useWildcards) {
                return Collections.emptyList();
            }
        };
    }

    @Produces
    public AuthenticationService getAuthenticationService() {
        return new AuthenticationService(){

            public User login(String s, String s2) {
                return EnvironmentProvider.this.cliIdentity;
            }

            public boolean isLoggedIn() {
                return false;
            }

            public void logout() {
            }

            public User getUser() {
                return EnvironmentProvider.this.cliIdentity;
            }
        };
    }
}

