/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.support;

import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.kie.config.cli.support.InputReader;

public class InteractiveUsernamePasswordCredentialsProvider
extends UsernamePasswordCredentialsProvider {
    private InputReader reader;

    public InteractiveUsernamePasswordCredentialsProvider(String username, String password, InputReader reader) {
        super(username, password);
        this.reader = reader;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        try {
            return super.get(uri, items);
        }
        catch (UnsupportedCredentialItem e) {
            for (CredentialItem i : items) {
                if (!(i instanceof CredentialItem.YesNoType)) continue;
                System.out.println(i.getPromptText() + " [yes|no]:");
                String response = this.reader.nextLine();
                if (response.equalsIgnoreCase("yes") || response.equalsIgnoreCase("y")) {
                    ((CredentialItem.YesNoType)i).setValue(true);
                } else {
                    ((CredentialItem.YesNoType)i).setValue(false);
                }
                return true;
            }
            return false;
        }
    }
}

