/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.command.impl;

import java.lang.annotation.Annotation;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.weld.environment.se.WeldContainer;
import org.kie.config.cli.CliContext;
import org.kie.config.cli.command.CliCommand;
import org.kie.config.cli.support.InputReader;

public class AddRepositoryToOrganizationalUnitCliCommand
implements CliCommand {
    @Override
    public String getName() {
        return "add-repo-org-unit";
    }

    @Override
    public String execute(CliContext context) {
        StringBuffer result = new StringBuffer();
        WeldContainer container = context.getContainer();
        OrganizationalUnitService organizationalUnitService = (OrganizationalUnitService)container.instance().select(OrganizationalUnitService.class, new Annotation[0]).get();
        RepositoryService repositoryService = (RepositoryService)container.instance().select(RepositoryService.class, new Annotation[0]).get();
        InputReader input = context.getInput();
        System.out.print(">>Organizational Unit name:");
        String name = input.nextLine();
        OrganizationalUnit organizationalUnit = organizationalUnitService.getOrganizationalUnit(name);
        if (organizationalUnit == null) {
            return "No Organizational Unit " + name + " was found";
        }
        System.out.print(">>Repository alias:");
        String alias = input.nextLine();
        Repository repo = repositoryService.getRepository(alias);
        if (repo == null) {
            return "No repository " + alias + " was found";
        }
        if (organizationalUnit.getRepositories().contains(repo)) {
            return "Repository " + alias + " is already added to " + name;
        }
        organizationalUnitService.addRepository(organizationalUnit, repo);
        result.append("Repository " + repo.getAlias() + " was successfully added to Organizational Unit " + organizationalUnit.getName());
        return result.toString();
    }
}

