/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.command.impl;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.weld.environment.se.WeldContainer;
import org.kie.config.cli.CliContext;
import org.kie.config.cli.command.CliCommand;
import org.kie.config.cli.support.InputReader;

public class CreateRepositoryCliCommand
implements CliCommand {
    @Override
    public String getName() {
        return "create-repo";
    }

    @Override
    public String execute(CliContext context) {
        StringBuffer result = new StringBuffer();
        WeldContainer container = context.getContainer();
        RepositoryService repositoryService = (RepositoryService)container.instance().select(RepositoryService.class, new Annotation[0]).get();
        String alias = null;
        InputReader input = context.getInput();
        while (alias == null) {
            System.out.print(">>Repository alias:");
            alias = input.nextLine();
            try {
                new URI("default://localhost/" + alias);
            }
            catch (URISyntaxException e) {
                System.err.print(">> Invalid value for repository alias: '" + alias + "'");
                alias = null;
            }
        }
        Repository repoCheck = repositoryService.getRepository(alias);
        if (repoCheck != null) {
            result.append(" Repository with alias: '" + alias + "' already exists, cannot proceed");
            return result.toString();
        }
        System.out.print(">>User:");
        String user = input.nextLine();
        System.out.print(">>Password:");
        String password = context.getInput().nextLineNoEcho();
        System.out.print(">>Remote origin:");
        String origin = input.nextLine();
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("username", user);
        env.put("crypt:password", password);
        if (origin.trim().length() > 0) {
            env.put("origin", origin);
        }
        env.put("managed", false);
        env.put("org.kie.config.cli.command.CliCommand", "CreateRepositoryCliCommand");
        Repository repo = repositoryService.createRepository("git", alias, env);
        result.append("Repository with alias " + repo.getAlias() + " has been successfully created");
        return result.toString();
    }
}

