/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.support;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Scanner;
import org.kie.config.cli.command.CliCommandRegistry;
import org.kie.config.cli.support.History;

public class InputReader {
    private InputStream input;
    private Scanner scanner;

    public InputReader(InputStream input, boolean useScanner) {
        this.input = input;
        if (useScanner) {
            this.scanner = new Scanner(new InputStreamReader(this.input));
        }
    }

    public String nextLine() {
        return this.nextLine(false, true);
    }

    public String nextLineNoEcho() {
        if (this.scanner != null && System.console() != null) {
            return new String(System.console().readPassword());
        }
        return this.nextLine(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextLine(boolean endAtTab, boolean echo) {
        if (this.scanner != null) {
            return this.scanner.nextLine();
        }
        StringWriter stringWritter = new StringWriter();
        BufferedWriter writter = new BufferedWriter(stringWritter);
        int data = 0;
        try {
            while ((data = this.input.read()) != -1) {
                String history;
                if (data == 27) {
                    data = this.input.read();
                    data = this.input.read();
                    if (data == 65) {
                        history = History.getPrevious();
                        if (history == null) continue;
                        this.clearLine(stringWritter, writter);
                        stringWritter = new StringWriter();
                        writter = new BufferedWriter(stringWritter);
                        System.out.print(history);
                        writter.write(history.toCharArray());
                        continue;
                    }
                    if (data == 66) {
                        history = History.getNext();
                        this.clearLine(stringWritter, writter);
                        stringWritter = new StringWriter();
                        writter = new BufferedWriter(stringWritter);
                        if (history == null) continue;
                        System.out.print(history);
                        writter.write(history.toCharArray());
                        continue;
                    }
                    if (data == 67 || data != 68) continue;
                    continue;
                }
                if (data == 13) {
                    writter.flush();
                    System.out.println();
                    history = stringWritter.toString();
                    return history;
                }
                if (endAtTab && data == 9) {
                    writter.flush();
                    String commandName = stringWritter.toString();
                    List<String> matches = CliCommandRegistry.get().findMatching(commandName);
                    if (matches.isEmpty()) continue;
                    if (matches.size() == 1) {
                        String matched = matches.get(0);
                        String remaining = matched.replaceFirst(commandName, "");
                        System.out.print(remaining);
                        writter.write(remaining.toCharArray());
                        continue;
                    }
                    for (String cmd : matches) {
                        System.out.println("\t" + cmd);
                    }
                    System.out.print(commandName);
                    continue;
                }
                if (data == 127) {
                    writter.flush();
                    StringBuffer buffer = stringWritter.getBuffer();
                    if (buffer.length() <= 0) continue;
                    buffer.deleteCharAt(buffer.length() - 1);
                    stringWritter.close();
                    writter.close();
                    stringWritter = new StringWriter();
                    writter = new BufferedWriter(stringWritter);
                    writter.write(buffer.toString().toCharArray());
                    System.out.print("\b \b");
                    continue;
                }
                writter.write(data);
                if (!echo) continue;
                System.out.print(Character.toChars(data));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                stringWritter.close();
                writter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void clearLine(StringWriter stringWritter, BufferedWriter writter) {
        try {
            writter.flush();
            StringBuffer buffer = stringWritter.getBuffer();
            if (buffer.length() > 0) {
                stringWritter.close();
                writter.close();
                for (int i = 0; i < buffer.length(); ++i) {
                    System.out.print("\b \b");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

