/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.command.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.util.AnnotationLiteral;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.backend.config.OrgUnit;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.weld.environment.se.WeldContainer;
import org.kie.config.cli.CliContext;
import org.kie.config.cli.command.CliCommand;
import org.kie.config.cli.support.InputReader;
import org.kie.workbench.common.screens.explorer.model.ProjectExplorerContent;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.ExplorerService;
import org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery;
import org.kie.workbench.common.services.shared.project.KieProjectService;

public class RemoveGroupFromProjectCliCommand
implements CliCommand {
    @Override
    public String getName() {
        return "remove-group-repo";
    }

    @Override
    public String execute(CliContext context) {
        StringBuffer result = new StringBuffer();
        WeldContainer container = context.getContainer();
        OrganizationalUnitService organizationalUnitService = (OrganizationalUnitService)container.instance().select(OrganizationalUnitService.class, new Annotation[0]).get();
        RepositoryService repositoryService = (RepositoryService)container.instance().select(RepositoryService.class, new Annotation[0]).get();
        ExplorerService projectExplorerService = (ExplorerService)container.instance().select(ExplorerService.class, new Annotation[0]).get();
        KieProjectService projectService = (KieProjectService)container.instance().select(KieProjectService.class, new Annotation[0]).get();
        InputReader input = context.getInput();
        System.out.print(">>Repository alias:");
        String alias = input.nextLine();
        Repository repo = repositoryService.getRepository(alias);
        if (repo == null) {
            return "No repository " + alias + " was found";
        }
        OrganizationalUnit ou = null;
        Collection units = organizationalUnitService.getOrganizationalUnits();
        for (OrganizationalUnit unit : units) {
            if (!unit.getRepositories().contains(repo)) continue;
            ou = unit;
            break;
        }
        ArrayList projects = new ArrayList();
        ProjectExplorerContentQuery query = new ProjectExplorerContentQuery(ou, repo, "master");
        query.setOptions(new ActiveOptions());
        ProjectExplorerContent content = projectExplorerService.getContent(query);
        projects.addAll(content.getProjects());
        if (projects.size() == 0) {
            return "No projects found in repository " + alias;
        }
        int projectIndex = 0;
        while (projectIndex == 0) {
            System.out.println(">>Select project:");
            for (int i = 0; i < projects.size(); ++i) {
                System.out.println(i + 1 + ") " + ((Project)projects.get(i)).getProjectName());
            }
            try {
                projectIndex = Integer.parseInt(input.nextLine());
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid index");
            }
            if (projectIndex >= 1 && projectIndex <= projects.size()) continue;
            projectIndex = 0;
            System.out.println("Invalid index");
        }
        Project project = (Project)projects.get(projectIndex - 1);
        if (project.getGroups() == null || project.getGroups().isEmpty()) {
            return "No groups defined for project " + project.getProjectName();
        }
        System.out.print(">>Security groups (comma separated list):");
        String groupsIn = input.nextLine();
        if (groupsIn.trim().length() > 0) {
            String[] groups;
            for (String group : groups = groupsIn.split(",")) {
                projectService.removeGroup(project, group);
                result.append("Group " + group + " removed successfully from project " + project.getProjectName() + "\n");
            }
        }
        container.getBeanManager().fireEvent((Object)new SystemRepositoryChangedEvent(), new Annotation[]{new AnnotationLiteral<org.guvnor.structure.backend.config.Repository>(){}});
        container.getBeanManager().fireEvent((Object)new SystemRepositoryChangedEvent(), new Annotation[]{new AnnotationLiteral<OrgUnit>(){}});
        return result.toString();
    }
}

