/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.support;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.DefaultPublicURI;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.config.SecureConfigItem;
import org.guvnor.structure.server.repositories.RepositoryFactoryHelper;
import org.kie.config.cli.support.GitRepositoryHelperContext;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GitRepositoryHelper
implements RepositoryFactoryHelper {
    private IOService ioService;
    @Inject
    private PasswordService secureService;
    @Inject
    private GitRepositoryHelperContext context;

    public GitRepositoryHelper() {
    }

    @Inject
    public GitRepositoryHelper(@Named(value="ioStrategy") IOService ioService) {
        this.ioService = ioService;
    }

    public boolean accept(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        return "git".equals(schemeConfigItem.getValue());
    }

    public Repository newRepository(ConfigGroup repoConfig) {
        this.validate(repoConfig);
        GitRepository repo = new GitRepository(repoConfig.getName());
        for (ConfigItem item : repoConfig.getItems()) {
            if (item instanceof SecureConfigItem) {
                repo.addEnvironmentParameter(item.getName(), (Object)this.secureService.decrypt(item.getValue().toString()));
                continue;
            }
            repo.addEnvironmentParameter(item.getName(), item.getValue());
        }
        if (!repo.isValid()) {
            throw new IllegalStateException("Repository " + repoConfig.getName() + " not valid");
        }
        Object command = repo.getEnvironment().get("org.kie.config.cli.command.CliCommand");
        if (command != null) {
            repo.getEnvironment().put("init", true);
        } else {
            String url = this.context.getScheme() + "://" + this.context.getUser() + "@" + this.context.getHost() + ":" + this.context.getPort() + "/" + repo.getAlias();
            repo.getEnvironment().put("origin", url);
            repo.getEnvironment().put("username", this.context.getUser());
            repo.getEnvironment().put("password", this.context.getPassword());
        }
        FileSystem fs = null;
        URI uri = null;
        try {
            uri = URI.create(repo.getUri());
            fs = this.ioService.newFileSystem(uri, new HashMap(repo.getEnvironment()));
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = this.ioService.getFileSystem(uri);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getCause().getMessage(), ex);
        }
        Map<String, org.uberfire.backend.vfs.Path> branches = this.getBranches(fs);
        repo.setBranches(branches);
        repo.setRoot(this.getDefaultRoot(fs, branches));
        String[] uris = fs.toString().split("\\r?\\n");
        ArrayList<DefaultPublicURI> publicURIs = new ArrayList<DefaultPublicURI>(uris.length);
        for (String s : uris) {
            int protocolStart = s.indexOf("://");
            DefaultPublicURI publicURI = protocolStart > 0 ? new DefaultPublicURI(s.substring(0, protocolStart), s) : new DefaultPublicURI(s);
            publicURIs.add(publicURI);
        }
        repo.setPublicURIs(publicURIs);
        return repo;
    }

    private org.uberfire.backend.vfs.Path getDefaultRoot(FileSystem fs, Map<String, org.uberfire.backend.vfs.Path> branches) {
        if (branches.containsKey("master")) {
            return branches.get("master");
        }
        return Paths.convert((Path)((Path)fs.getRootDirectories().iterator().next()));
    }

    private Map<String, org.uberfire.backend.vfs.Path> getBranches(FileSystem fs) {
        HashMap<String, org.uberfire.backend.vfs.Path> branches = new HashMap<String, org.uberfire.backend.vfs.Path>();
        for (Path path : fs.getRootDirectories()) {
            String gitBranch = this.getBranchName(path);
            branches.put(gitBranch, Paths.convert((Path)path));
        }
        return branches;
    }

    protected String getBranchName(Path path) {
        URI uri = path.toUri();
        String gitBranch = uri.getAuthority();
        if (gitBranch.indexOf("@") != -1) {
            return gitBranch.split("@")[0];
        }
        return gitBranch;
    }

    private void validate(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
    }
}

