/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.gwt.functions.rebind;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.kie.dmn.feel.gwt.functions.api.FunctionDefinition;
import org.kie.dmn.feel.gwt.functions.api.FunctionOverrideVariation;
import org.kie.dmn.feel.gwt.functions.api.Parameter;
import org.kie.dmn.feel.gwt.functions.api.Type;
import org.kie.dmn.feel.gwt.functions.client.FEELFunctionProvider;
import org.kie.dmn.feel.gwt.functions.rebind.MethodTemplates;
import org.kie.dmn.feel.lang.types.BuiltInType;

class FileCreator {
    public static final String GENERATED_CLASS_FQCN = FEELFunctionProvider.class.getSimpleName() + "Impl";
    public static final String PACKAGE_NAME = FEELFunctionProvider.class.getPackage().getName();
    private final TreeLogger logger;
    private final GeneratorContext context;

    public FileCreator(GeneratorContext context, TreeLogger logger) {
        this.logger = logger;
        this.context = context;
    }

    private Optional<SourceWriter> getSourceWriter(GeneratorContext context, TreeLogger logger) {
        ClassSourceFileComposerFactory composerFactory = this.getClassSourceFileComposerFactory();
        Optional<PrintWriter> printWriter = Optional.ofNullable(context.tryCreate(logger, PACKAGE_NAME, GENERATED_CLASS_FQCN));
        return printWriter.map(pw -> composerFactory.createSourceWriter(context, pw));
    }

    ClassSourceFileComposerFactory getClassSourceFileComposerFactory() {
        ClassSourceFileComposerFactory composerFactory = this.makeComposerFactory();
        composerFactory.addImport(FEELFunctionProvider.class.getCanonicalName());
        composerFactory.addImport(FunctionDefinition.class.getCanonicalName());
        composerFactory.addImport(FunctionOverrideVariation.class.getCanonicalName());
        composerFactory.addImport(BuiltInType.class.getCanonicalName());
        composerFactory.addImport(Parameter.class.getCanonicalName());
        composerFactory.addImport(List.class.getCanonicalName());
        composerFactory.addImport(ArrayList.class.getCanonicalName());
        composerFactory.addImport(Type.class.getCanonicalName());
        composerFactory.addImplementedInterface(FEELFunctionProvider.class.getName());
        return composerFactory;
    }

    public void write() {
        this.getSourceWriter(this.context, this.logger).ifPresent(sourceWriter -> {
            String template = MethodTemplates.getTemplate();
            sourceWriter.print(template);
            sourceWriter.commit(this.logger);
        });
    }

    ClassSourceFileComposerFactory makeComposerFactory() {
        return new ClassSourceFileComposerFactory(PACKAGE_NAME, GENERATED_CLASS_FQCN);
    }
}

