/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.DateAndTimeFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class TimeFunction
extends BaseFEELFunction {
    public static final DateTimeFormatter FEEL_TIME;
    public static final TimeFunction INSTANCE;
    private static final BigDecimal NANO_MULT;

    public TimeFunction() {
        super("time");
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="from") String val) {
        if (val == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        try {
            TemporalAccessor parsed = FEEL_TIME.parse(val);
            if (parsed.query(TemporalQueries.offset()) != null) {
                OffsetTime asOffSetTime = parsed.query(OffsetTime::from);
                return FEELFnResult.ofResult((Object)asOffSetTime);
            }
            if (parsed.query(TemporalQueries.zone()) == null) {
                LocalTime asLocalTime = parsed.query(LocalTime::from);
                return FEELFnResult.ofResult((Object)asLocalTime);
            }
            return FEELFnResult.ofResult((Object)parsed);
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", (Throwable)e));
        }
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="hour") Number hour, @ParameterName(value="minute") Number minute, @ParameterName(value="second") Number seconds) {
        return this.invoke(hour, minute, seconds, null);
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="hour") Number hour, @ParameterName(value="minute") Number minute, @ParameterName(value="second") Number seconds, @ParameterName(value="offset") Duration offset) {
        if (hour == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "hour", "cannot be null"));
        }
        if (minute == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "minute", "cannot be null"));
        }
        if (seconds == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "seconds", "cannot be null"));
        }
        try {
            int nanosecs = 0;
            if (seconds instanceof BigDecimal) {
                BigDecimal secs = (BigDecimal)seconds;
                nanosecs = secs.subtract(secs.setScale(0, 1)).multiply(NANO_MULT).intValue();
            }
            if (offset == null) {
                return FEELFnResult.ofResult((Object)LocalTime.of(hour.intValue(), minute.intValue(), seconds.intValue(), nanosecs));
            }
            return FEELFnResult.ofResult((Object)OffsetTime.of(hour.intValue(), minute.intValue(), seconds.intValue(), nanosecs, ZoneOffset.ofTotalSeconds((int)offset.getSeconds())));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "time-parsing exception", (Throwable)e));
        }
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="from") TemporalAccessor date) {
        if (date == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        try {
            if (!date.isSupported(ChronoField.HOUR_OF_DAY)) {
                return (FEELFnResult)new DateAndTimeFunction().invoke(date, OffsetTime.of(0, 0, 0, 0, ZoneOffset.UTC)).cata(overrideLeft -> FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "time-parsing exception")), this::invoke);
            }
            if (date.query(TemporalQueries.offset()) == null) {
                return FEELFnResult.ofResult((Object)LocalTime.from(date));
            }
            ZoneId zone = date.query(TemporalQueries.zoneId());
            if (!(zone instanceof ZoneOffset)) {
                return this.invoke(date.query(TemporalQueries.localTime()) + "@" + zone);
            }
            return FEELFnResult.ofResult((Object)OffsetTime.from(date));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "time-parsing exception", (Throwable)e));
        }
    }

    static {
        INSTANCE = new TimeFunction();
        FEEL_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendLiteral("@").appendZoneRegionId().optionalEnd().optionalStart().appendOffsetId().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.STRICT);
        NANO_MULT = BigDecimal.valueOf(1000000000L);
    }
}

