/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.List;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class DurationFunction
extends BaseFEELFunction {
    public static final DurationFunction INSTANCE = new DurationFunction();

    DurationFunction() {
        super("duration");
    }

    public FEELFnResult<TemporalAmount> invoke(@ParameterName(value="from") String val) {
        if (val == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        try {
            return FEELFnResult.ofResult((Object)Duration.parse(val));
        }
        catch (DateTimeParseException e) {
            try {
                return FEELFnResult.ofResult((Object)ComparablePeriod.parse((CharSequence)val).normalized());
            }
            catch (DateTimeParseException e2) {
                return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "date-parsing exception", (Throwable)new RuntimeException(new Throwable(){
                    public final List<Throwable> causes;
                    {
                        this.causes = Arrays.asList(e, e2);
                    }
                })));
            }
        }
    }

    public FEELFnResult<TemporalAmount> invoke(@ParameterName(value="from") TemporalAmount val) {
        if (val == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        return FEELFnResult.ofResult((Object)val);
    }
}

