/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.time.Period;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.Visitor;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;
import org.kie.dmn.feel.util.AssignableFromUtil;
import org.kie.dmn.feel.util.Msg;

public class RangeNode
extends BaseNode {
    private IntervalBoundary lowerBound;
    private IntervalBoundary upperBound;
    private BaseNode start;
    private BaseNode end;

    public RangeNode(ParserRuleContext ctx, IntervalBoundary lowerBound, BaseNode start, BaseNode end, IntervalBoundary upperBound) {
        super(ctx);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.start = start;
        this.end = end;
    }

    public IntervalBoundary getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(IntervalBoundary lowerBound) {
        this.lowerBound = lowerBound;
    }

    public IntervalBoundary getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(IntervalBoundary upperBound) {
        this.upperBound = upperBound;
    }

    public BaseNode getStart() {
        return this.start;
    }

    public void setStart(BaseNode start) {
        this.start = start;
    }

    public BaseNode getEnd() {
        return this.end;
    }

    public void setEnd(BaseNode end) {
        this.end = end;
    }

    public Range evaluate(EvaluationContext ctx) {
        Object s = this.start.evaluate(ctx);
        Object e = this.end.evaluate(ctx);
        Type sType = BuiltInType.determineTypeFromInstance((Object)s);
        Type eType = BuiltInType.determineTypeFromInstance((Object)e);
        if (s != null && e != null && sType != eType && !AssignableFromUtil.isAssignableFrom(s.getClass(), e.getClass())) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.X_TYPE_INCOMPATIBLE_WITH_Y_TYPE, "Start", "End")));
            return null;
        }
        Comparable start = this.convertToComparable(ctx, s);
        Comparable end = this.convertToComparable(ctx, e);
        return new RangeImpl(this.lowerBound == IntervalBoundary.OPEN ? Range.RangeBoundary.OPEN : Range.RangeBoundary.CLOSED, start, end, this.upperBound == IntervalBoundary.OPEN ? Range.RangeBoundary.OPEN : Range.RangeBoundary.CLOSED);
    }

    private Comparable convertToComparable(EvaluationContext ctx, Object s) {
        Comparable start;
        if (s == null) {
            start = null;
        } else if (s instanceof Comparable) {
            start = (Comparable)s;
        } else if (s instanceof Period) {
            start = new ComparablePeriod((Period)s);
        } else {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INCOMPATIBLE_TYPE_FOR_RANGE, s.getClass().getSimpleName())));
            start = null;
        }
        return start;
    }

    public Type getResultType() {
        return BuiltInType.RANGE;
    }

    public ASTNode[] getChildrenNode() {
        return new ASTNode[]{this.start, this.end};
    }

    public <T> T accept(Visitor<T> v) {
        return (T)v.visit(this);
    }

    public static enum IntervalBoundary {
        OPEN,
        CLOSED;


        public static IntervalBoundary low(String input) {
            switch (input) {
                case "[": {
                    return CLOSED;
                }
            }
            return OPEN;
        }

        public static IntervalBoundary high(String input) {
            switch (input) {
                case "]": {
                    return CLOSED;
                }
            }
            return OPEN;
        }
    }
}

