/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import com.google.gwt.regexp.shared.RegExp;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class DateFunction
extends BaseFEELFunction {
    public static final RegExp BEGIN_YEAR = RegExp.compile((String)"^-?(([1-9]\\d\\d\\d+)|(0\\d\\d\\d))-");
    public static final DateTimeFormatter FEEL_DATE;
    public static final DateFunction INSTANCE;

    public DateFunction() {
        super("date");
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="from") String val) {
        if (val == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        if (BEGIN_YEAR.exec(val) == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "year not compliant with XML Schema Part 2 Datatypes"));
        }
        try {
            return FEELFnResult.ofResult((Object)LocalDate.from(FEEL_DATE.parse(val)));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "date", (Throwable)e));
        }
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="year") Number year, @ParameterName(value="month") Number month, @ParameterName(value="day") Number day) {
        if (year == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "year", "cannot be null"));
        }
        if (month == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "month", "cannot be null"));
        }
        if (day == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "day", "cannot be null"));
        }
        try {
            return FEELFnResult.ofResult((Object)LocalDate.of(year.intValue(), month.intValue(), day.intValue()));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "input parameters date-parsing exception", (Throwable)e));
        }
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="from") TemporalAccessor date) {
        if (date == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        try {
            return FEELFnResult.ofResult((Object)LocalDate.from(date));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "date-parsing exception", (Throwable)e));
        }
    }

    static {
        INSTANCE = new DateFunction();
        FEEL_DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 9, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter().withResolverStyle(ResolverStyle.STRICT);
    }
}

