/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class MatchesFunction
extends BaseFEELFunction {
    public MatchesFunction() {
        super("matches");
    }

    public FEELFnResult<Boolean> invoke(@ParameterName(value="input") String input, @ParameterName(value="pattern") String pattern) {
        return this.invoke(input, pattern, null);
    }

    public FEELFnResult<Boolean> invoke(@ParameterName(value="input") String input, @ParameterName(value="pattern") String pattern, @ParameterName(value="flags") String flags) {
        if (input == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "input", "cannot be null"));
        }
        if (pattern == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "pattern", "cannot be null"));
        }
        try {
            RegExp p = RegExp.compile((String)pattern, (String)flags);
            MatchResult m = p.exec(input);
            return FEELFnResult.ofResult((Object)(m != null ? 1 : 0));
        }
        catch (IllegalArgumentException t) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "flags", "contains unknown flags", (Throwable)t));
        }
        catch (Throwable t) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "pattern", "is invalid and can not be compiled", t));
        }
    }
}

