/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.dmn.feel.runtime.functions;

import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.TemporalAmount;

public class YearsAndMonthsFunction
        extends BaseFEELFunction {

    public YearsAndMonthsFunction() {
        super( "years and months duration" );
    }

    public TemporalAmount apply(@ParameterName("from") LocalDate from, @ParameterName("to") LocalDate to) {
        if ( from != null && to != null ) {
            return Period.between( from, to ).withDays( 0 );
        }
        return null;
    }

}
