/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTest;

public class InNode
extends BaseNode {
    private BaseNode value;
    private BaseNode exprs;

    public InNode(ParserRuleContext ctx, BaseNode value, BaseNode exprs) {
        super(ctx);
        this.value = value;
        this.exprs = exprs;
    }

    public BaseNode getValue() {
        return this.value;
    }

    public void setValue(BaseNode value) {
        this.value = value;
    }

    public BaseNode getExprs() {
        return this.exprs;
    }

    public void setExprs(BaseNode exprs) {
        this.exprs = exprs;
    }

    @Override
    public Boolean evaluate(EvaluationContext ctx) {
        Object value = this.value.evaluate(ctx);
        Object expr = this.exprs.evaluate(ctx);
        if (expr != null) {
            if (expr instanceof Iterable) {
                for (Object e : (Iterable)expr) {
                    if (this.in(value, e) != Boolean.TRUE) continue;
                    return true;
                }
                return false;
            }
            return this.in(value, expr);
        }
        return null;
    }

    private Boolean in(Object value, Object expr) {
        if (expr == null) {
            return value == expr;
        }
        if (expr instanceof UnaryTest) {
            return (Boolean)((UnaryTest)expr).apply(value);
        }
        if (expr instanceof Range) {
            if (!(value instanceof Comparable)) {
                return null;
            }
            return ((Range)expr).includes((Comparable)value);
        }
        if (value != null) {
            return value.equals(expr);
        }
        return Boolean.FALSE;
    }
}

