/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.parser.feel11;

import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.kie.dmn.feel.lang.Scope;
import org.kie.dmn.feel.lang.types.ScopeImpl;
import org.kie.dmn.feel.lang.types.SymbolTable;
import org.kie.dmn.feel.lang.types.VariableSymbol;

public class ParserHelper {
    private SymbolTable symbols = new SymbolTable();
    private Scope currentScope = this.symbols.getGlobalScope();
    private Stack<String> currentName = new Stack();

    public ParserHelper() {
        this.currentName.push("<local>");
    }

    public SymbolTable getSymbolTable() {
        return this.symbols;
    }

    public void pushScope() {
        this.currentScope = new ScopeImpl(this.currentName.peek(), this.currentScope);
    }

    public void popScope() {
        this.currentScope = this.currentScope.getParentScope();
    }

    public void pushName(String name) {
        this.currentName.push(name);
    }

    public void pushName(ParserRuleContext ctx) {
        this.currentName.push(this.getOriginalText(ctx));
    }

    public void popName() {
        this.currentName.pop();
    }

    public void recoverScope() {
        this.recoverScope(this.currentName.peek());
    }

    public void recoverScope(String name) {
        Scope s = this.currentScope.getChildScopes().get(name);
        if (s != null) {
            this.currentScope = s;
        } else {
            this.pushScope();
        }
    }

    public void dismissScope() {
        this.popScope();
    }

    public void defineVariable(ParserRuleContext ctx) {
        this.defineVariable(this.getOriginalText(ctx));
    }

    public void defineVariable(String variable) {
        VariableSymbol var = new VariableSymbol(variable);
        this.currentScope.define(var);
    }

    public void startVariable(Token t) {
        this.currentScope.start(t.getText());
    }

    public boolean followUp(Token t, boolean isPredict) {
        boolean follow = this.currentScope.followUp(t.getText(), isPredict);
        return follow;
    }

    private String getOriginalText(ParserRuleContext ctx) {
        int a = ctx.start.getStartIndex();
        int b = ctx.stop.getStopIndex();
        Interval interval = new Interval(a, b);
        return ctx.getStart().getInputStream().getText(interval);
    }

    public static List<Token> getAllTokens(ParseTree ctx, List<Token> tokens) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof TerminalNode) {
                tokens.add(((TerminalNode)child).getSymbol());
                continue;
            }
            ParserHelper.getAllTokens(child, tokens);
        }
        return tokens;
    }
}

