/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.decisiontables;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.decisiontables.DTDecisionRule;
import org.kie.dmn.feel.runtime.decisiontables.DTInputClause;
import org.kie.dmn.feel.runtime.decisiontables.HitPolicy;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTInvokerFunction
extends BaseFEELFunction {
    private static final Logger logger = LoggerFactory.getLogger(DTInvokerFunction.class);
    private List<DTDecisionRule> decisionRules;
    private List<DTInputClause> inputs;
    private final HitPolicy hitPolicy;

    public DTInvokerFunction(String name, List<DTInputClause> inputs, List<DTDecisionRule> decisionRules, HitPolicy hitPolicy) {
        super(name);
        this.decisionRules = decisionRules;
        this.inputs = inputs;
        this.hitPolicy = hitPolicy;
    }

    public Object apply(EvaluationContext ctx, Object[] params) {
        if (this.decisionRules.isEmpty()) {
            return null;
        }
        if (params.length != this.decisionRules.get(0).getInputEntry().size()) {
            logger.error("The parameters supplied does not match input expression list");
            return null;
        }
        for (DTDecisionRule decisionRule : this.decisionRules) {
            Boolean ruleMatches = IntStream.range(0, params.length).mapToObj(i -> DTInvokerFunction.satisfies(params[i], decisionRule.getInputEntry().get(i), this.inputs.get(i).getInputValues())).reduce((a, b) -> a != false && b != false).orElse(false);
            if (!ruleMatches.booleanValue()) continue;
            if (decisionRule.getOutputEntry().size() == 1) {
                return decisionRule.getOutputEntry().get(0);
            }
            return decisionRule.getOutputEntry();
        }
        return null;
    }

    public static boolean satisfies(Object inputExpressionE, UnaryTest inputEntryT, List<UnaryTest> inputValuesV) {
        boolean EinV;
        if (inputValuesV == null || inputValuesV.size() == 0 ? inputExpressionE == null : !(EinV = inputValuesV.stream().map(vut -> (Boolean)vut.apply(inputExpressionE)).filter(Boolean::booleanValue).findAny().orElse(false).booleanValue())) {
            return false;
        }
        return (Boolean)inputEntryT.apply(inputExpressionE);
    }

    @Override
    protected boolean isCustomFunction() {
        return true;
    }

    public List<List<String>> getParameterNames() {
        return Arrays.asList(this.inputs.stream().map(DTInputClause::getInputExpression).collect(Collectors.toList()));
    }

    public HitPolicy getHitPolicy() {
        return this.hitPolicy;
    }
}

