/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class DateFunction
extends BaseFEELFunction {
    public DateFunction() {
        super("date");
    }

    public TemporalAccessor apply(@ParameterName(value="from") String val) {
        if (val != null) {
            return LocalDate.from(DateTimeFormatter.ISO_DATE.parse(val));
        }
        return null;
    }

    public TemporalAccessor apply(@ParameterName(value="year") Number year, @ParameterName(value="month") Number month, @ParameterName(value="day") Number day) {
        if (year != null && month != null && day != null) {
            return LocalDate.of(year.intValue(), month.intValue(), day.intValue());
        }
        return null;
    }

    public TemporalAccessor apply(@ParameterName(value="from") TemporalAccessor date) {
        if (date != null) {
            return LocalDate.from(date);
        }
        return null;
    }
}

