/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.decisiontables.DTDecisionRule;
import org.kie.dmn.feel.runtime.decisiontables.DTInputClause;
import org.kie.dmn.feel.runtime.decisiontables.DTInvokerFunction;
import org.kie.dmn.feel.runtime.decisiontables.HitPolicy;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTableFunction
extends BaseFEELFunction {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionTableFunction.class);

    public DecisionTableFunction() {
        super("decision table");
    }

    public Object apply(@ParameterName(value="outputs") Object outputs, @ParameterName(value="input expression list") Object inputExpressionList, @ParameterName(value="input values list") List<?> inputValuesList, @ParameterName(value="output values") Object outputValues, @ParameterName(value="rule list") List<List> ruleList, @ParameterName(value="hit policy") String hitPolicy, @ParameterName(value="default output value") Object defaultOutputValue) {
        List<DTInputClause> inputs;
        List<String> inputExpressions;
        List<String> list = inputExpressions = inputExpressionList instanceof List ? (List<String>)inputExpressionList : Collections.singletonList((String)inputExpressionList);
        if (inputValuesList != null) {
            List inputValues = inputValuesList.stream().map(DecisionTableFunction::toUnaryTest).collect(Collectors.toList());
            if (inputValues.size() != inputExpressions.size()) {
                // empty if block
            }
            inputs = IntStream.range(0, inputExpressions.size()).mapToObj(i -> new DTInputClause((String)inputExpressions.get(i), Collections.singletonList(inputValues.get(i)))).collect(Collectors.toList());
        } else {
            inputs = inputExpressions.stream().map(ie -> new DTInputClause((String)ie, null)).collect(Collectors.toList());
        }
        List<DTDecisionRule> decisionRules = ruleList.stream().map(o -> DecisionTableFunction.toDecisionRule(o, inputExpressions.size())).collect(Collectors.toList());
        return new DTInvokerFunction(UUID.randomUUID().toString(), inputs, decisionRules, HitPolicy.fromString(hitPolicy));
    }

    public static DTDecisionRule toDecisionRule(List<?> rule, int inputSize) {
        DTDecisionRule dr = new DTDecisionRule();
        for (int i = 0; i < rule.size(); ++i) {
            Object o = rule.get(i);
            if (i < inputSize) {
                dr.getInputEntry().add(DecisionTableFunction.toUnaryTest(o));
                continue;
            }
            dr.getOutputEntry().add(o);
        }
        return dr;
    }

    private static UnaryTest toUnaryTest(Object o) {
        if (o instanceof UnaryTest) {
            return (UnaryTest)o;
        }
        if (o instanceof Range) {
            return x -> ((Range)o).includes((Comparable)x);
        }
        if (o instanceof List) {
            return x -> ((List)o).contains(x);
        }
        return x -> x.equals(o);
    }
}

