/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class SubstringFunction
extends BaseFEELFunction {
    public SubstringFunction() {
        super("substring");
    }

    public String apply(@ParameterName(value="string") String string, @ParameterName(value="start position") Number start) {
        if (string == null || start == null || Math.abs(start.intValue()) > string.length()) {
            return null;
        }
        if (start.intValue() > 0) {
            return string.substring(start.intValue() - 1);
        }
        if (start.intValue() < 0) {
            return string.substring(string.length() + start.intValue());
        }
        return null;
    }

    public String apply(@ParameterName(value="string") String string, @ParameterName(value="start position") Number start, @ParameterName(value="length") Number length) {
        if (string == null || start == null || Math.abs(start.intValue()) > string.length()) {
            return null;
        }
        if (start.intValue() > 0) {
            return string.substring(start.intValue() - 1, Math.min(string.length(), start.intValue() + length.intValue() - 1));
        }
        if (start.intValue() < 0) {
            return string.substring(string.length() + start.intValue(), Math.min(string.length(), string.length() + start.intValue() + length.intValue()));
        }
        return null;
    }
}

