/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.Duration;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class TimeFunction
extends BaseFEELFunction {
    public TimeFunction() {
        super("time");
    }

    public TemporalAccessor apply(@ParameterName(value="from") String val) {
        if (val != null) {
            return DateTimeFormatter.ISO_TIME.parseBest(val, OffsetTime::from, LocalTime::from);
        }
        return null;
    }

    public TemporalAccessor apply(@ParameterName(value="hour") Number hour, @ParameterName(value="minute") Number minute, @ParameterName(value="second") Number seconds, @ParameterName(value="offset") Duration offset) {
        if (hour != null && minute != null && seconds != null) {
            if (offset == null) {
                return LocalTime.of(hour.intValue(), minute.intValue(), seconds.intValue());
            }
            return OffsetTime.of(hour.intValue(), minute.intValue(), seconds.intValue(), 0, ZoneOffset.ofTotalSeconds((int)offset.getSeconds()));
        }
        return null;
    }

    public TemporalAccessor apply(@ParameterName(value="from") TemporalAccessor date) {
        if (date != null) {
            return OffsetTime.from(date);
        }
        return null;
    }
}

