/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.lang.ast.QualifiedNameNode;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionInvocationNode
extends BaseNode {
    private static final Logger logger = LoggerFactory.getLogger(FunctionInvocationNode.class);
    private BaseNode name;
    private ListNode params;

    public FunctionInvocationNode(ParserRuleContext ctx, BaseNode name, ListNode params) {
        super(ctx);
        this.name = name;
        this.params = params;
    }

    public BaseNode getName() {
        return this.name;
    }

    public void setName(BaseNode name) {
        this.name = name;
    }

    public ListNode getParams() {
        return this.params;
    }

    public void setParams(ListNode params) {
        this.params = params;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        Object p;
        FEELFunction function = null;
        Object value = null;
        if (this.name instanceof NameRefNode) {
            value = ctx.getValue(this.name.getText());
        } else {
            QualifiedNameNode qn = (QualifiedNameNode)this.name;
            String[] qns = qn.getPartsAsStringArray();
            value = ctx.getValue(qns);
        }
        if (value instanceof FEELFunction) {
            function = (FEELFunction)value;
            if (function != null) {
                p = this.params.getElements().stream().map(e -> e.evaluate(ctx)).toArray(Object[]::new);
                Object result = function.applyReflectively(ctx, (Object[])p);
                return result;
            }
            logger.error("Function not found: '" + this.name.getText() + "'");
        } else if (value instanceof UnaryTest) {
            if (this.params.getElements().size() == 1) {
                p = this.params.getElements().get(0).evaluate(ctx);
                return ((UnaryTest)value).apply(p);
            }
            logger.error("Can't invoke an unary test with " + this.params.getElements().size() + " parameters. Unary tests require 1 single parameter.");
        }
        return null;
    }
}

