/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFEELFunction
extends BaseFEELFunction {
    private static final Logger logger = LoggerFactory.getLogger(CustomFEELFunction.class);
    private final List<String> parameters;
    private final BaseNode body;

    public CustomFEELFunction(String name, List<String> parameters, BaseNode body) {
        super(name);
        this.parameters = parameters;
        this.body = body;
    }

    public List<List<String>> getParameterNames() {
        return Arrays.asList(this.parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apply(EvaluationContext ctx, Object[] params) {
        if (params.length != this.parameters.size()) {
            logger.error("Illegal invocation of function. Expecting " + this.getSignature() + " but got " + this.getName() + "( " + Arrays.asList(params) + " )");
            return null;
        }
        try {
            Object result;
            ctx.enterFrame();
            for (int i = 0; i < this.parameters.size(); ++i) {
                ctx.setValue(this.parameters.get(i), params[i]);
            }
            Object object = result = this.body.evaluate(ctx);
            return object;
        }
        catch (Exception e) {
            logger.error("Error invoking function " + this.getSignature() + ".", (Throwable)e);
        }
        finally {
            ctx.exitFrame();
        }
        return null;
    }

    private String getSignature() {
        return this.getName() + "( " + this.parameters.stream().collect(Collectors.joining(", ")) + " )";
    }

    @Override
    protected boolean isCustomFunction() {
        return true;
    }

    public String toString() {
        return "function " + this.getSignature();
    }
}

