/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Collections;
import java.util.List;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTableImpl;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTInvokerFunction
extends BaseFEELFunction {
    private static final Logger logger = LoggerFactory.getLogger(DTInvokerFunction.class);
    private final DecisionTableImpl dt;

    public DTInvokerFunction(DecisionTableImpl dt) {
        super(dt.getName());
        this.dt = dt;
    }

    public Object apply(EvaluationContext ctx, Object[] params) {
        try {
            Object result;
            ctx.enterFrame();
            for (int i = 0; i < params.length; ++i) {
                ctx.setValue(this.dt.getParameterNames().get(i), params[i]);
            }
            Object object = result = this.dt.evaluate(ctx, params);
            return object;
        }
        catch (Exception e) {
            logger.error("Error invoking decision table '" + this.getName() + "'.", (Throwable)e);
            throw e;
        }
        finally {
            ctx.exitFrame();
        }
    }

    @Override
    protected boolean isCustomFunction() {
        return true;
    }

    public DecisionTableImpl getDecisionTable() {
        return this.dt;
    }

    public List<List<String>> getParameterNames() {
        return Collections.singletonList(this.dt.getParameterNames());
    }
}

