/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.decisiontables.DTDecisionRule;
import org.kie.dmn.feel.runtime.decisiontables.DTInputClause;
import org.kie.dmn.feel.runtime.decisiontables.DTOutputClause;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTableImpl;
import org.kie.dmn.feel.runtime.decisiontables.HitPolicy;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.DTInvokerFunction;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTableFunction
extends BaseFEELFunction {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionTableFunction.class);

    public DecisionTableFunction() {
        super("decision table");
    }

    public Object apply(@ParameterName(value="outputs") Object outputs, @ParameterName(value="input expression list") Object inputExpressionList, @ParameterName(value="input values list") List<?> inputValuesList, @ParameterName(value="output values") Object outputValues, @ParameterName(value="rule list") List<List> ruleList, @ParameterName(value="hit policy") String hitPolicy, @ParameterName(value="default output value") Object defaultOutputValue) {
        ArrayList<DTOutputClause> outputClauses;
        List<String> parseOutputs;
        List<DTInputClause> inputs;
        List<String> inputExpressions;
        List<String> list = inputExpressions = inputExpressionList instanceof List ? (List<String>)inputExpressionList : Collections.singletonList((String)inputExpressionList);
        if (inputValuesList != null) {
            List inputValues = inputValuesList.stream().map(DecisionTableFunction::toUnaryTest).collect(Collectors.toList());
            if (inputValues.size() != inputExpressions.size()) {
                // empty if block
            }
            inputs = IntStream.range(0, inputExpressions.size()).mapToObj(i -> new DTInputClause((String)inputExpressions.get(i), inputValuesList.toString(), Collections.singletonList(inputValues.get(i)))).collect(Collectors.toList());
        } else {
            inputs = inputExpressions.stream().map(ie -> new DTInputClause((String)ie, null, null)).collect(Collectors.toList());
        }
        List<String> list2 = parseOutputs = outputs instanceof List ? (List<String>)outputs : Collections.singletonList((String)outputs);
        if (outputValues != null) {
            if (parseOutputs.size() == 1) {
                outputClauses = new ArrayList();
                outputClauses.add(new DTOutputClause(parseOutputs.get(0), (List)outputValues));
            } else {
                List listOfList = (List)outputValues;
                outputClauses = IntStream.range(0, parseOutputs.size()).mapToObj(i -> new DTOutputClause((String)parseOutputs.get(i), (List)listOfList.get(i))).collect(Collectors.toList());
            }
        } else {
            outputClauses = parseOutputs.stream().map(out -> new DTOutputClause((String)out, null)).collect(Collectors.toList());
        }
        List<DTDecisionRule> decisionRules = IntStream.range(0, ruleList.size()).mapToObj(index -> DecisionTableFunction.toDecisionRule(index, (List)ruleList.get(index), inputExpressions.size())).collect(Collectors.toList());
        DecisionTableImpl dti = new DecisionTableImpl(UUID.randomUUID().toString(), inputExpressions, inputs, outputClauses, decisionRules, HitPolicy.fromString(hitPolicy));
        return new DTInvokerFunction(dti);
    }

    public static DTDecisionRule toDecisionRule(int index, List<?> rule, int inputSize) {
        DTDecisionRule dr = new DTDecisionRule(index);
        for (int i = 0; i < rule.size(); ++i) {
            Object o = rule.get(i);
            if (i < inputSize) {
                dr.getInputEntry().add(DecisionTableFunction.toUnaryTest(o));
                continue;
            }
            dr.getOutputEntry().add((String)o);
        }
        return dr;
    }

    private static UnaryTest toUnaryTest(Object o) {
        if (o instanceof UnaryTest) {
            return (UnaryTest)o;
        }
        if (o instanceof Range) {
            return x -> ((Range)o).includes((Comparable)x);
        }
        if (o instanceof List) {
            return x -> ((List)o).contains(x);
        }
        return x -> x.equals(o);
    }
}

