/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFunction
extends BaseFEELFunction {
    private static final Logger logger = LoggerFactory.getLogger(JavaFunction.class);
    private final List<String> parameters;
    private final Class clazz;
    private final Method method;

    public JavaFunction(String name, List<String> parameters, Class clazz, Method method) {
        super(name);
        this.parameters = parameters;
        this.clazz = clazz;
        this.method = method;
    }

    public List<List<String>> getParameterNames() {
        return Arrays.asList(this.parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apply(EvaluationContext ctx, Object[] params) {
        if (params.length != this.parameters.size()) {
            logger.error("Illegal invocation of function. Expecting " + this.getSignature() + " but got " + this.getName() + "( " + Arrays.asList(params) + " )");
            return null;
        }
        try {
            Object result;
            ctx.enterFrame();
            for (int i = 0; i < this.parameters.size(); ++i) {
                ctx.setValue(this.parameters.get(i), params[i]);
            }
            Object[] actualParams = this.prepareParams(params);
            Object object = result = this.method.invoke((Object)this.clazz, actualParams);
            return object;
        }
        catch (Exception e) {
            logger.error("Error invoking function " + this.getSignature() + ".", (Throwable)e);
        }
        finally {
            ctx.exitFrame();
        }
        return null;
    }

    private Object[] prepareParams(Object[] params) {
        Object[] actual = new Object[params.length];
        Class<?>[] paramTypes = this.method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i].isAssignableFrom(params[i].getClass())) {
                actual[i] = params[i];
                continue;
            }
            if (params[i] == null) {
                actual[i] = null;
                continue;
            }
            if (params[i] instanceof Number) {
                if (paramTypes[i] == Byte.TYPE || paramTypes[i] == Byte.class) {
                    actual[i] = ((Number)params[i]).byteValue();
                    continue;
                }
                if (paramTypes[i] == Short.TYPE || paramTypes[i] == Short.class) {
                    actual[i] = ((Number)params[i]).shortValue();
                    continue;
                }
                if (paramTypes[i] == Integer.TYPE || paramTypes[i] == Integer.class) {
                    actual[i] = ((Number)params[i]).intValue();
                    continue;
                }
                if (paramTypes[i] == Long.TYPE || paramTypes[i] == Long.class) {
                    actual[i] = ((Number)params[i]).longValue();
                    continue;
                }
                if (paramTypes[i] == Float.TYPE || paramTypes[i] == Float.class) {
                    actual[i] = Float.valueOf(((Number)params[i]).floatValue());
                    continue;
                }
                if (paramTypes[i] == Double.TYPE || paramTypes[i] == Double.class) {
                    actual[i] = ((Number)params[i]).doubleValue();
                    continue;
                }
                throw new IllegalArgumentException("Unable to coerce parameter " + this.parameters.get(0) + ". Expected " + paramTypes[i] + " but found " + params[i].getClass());
            }
            throw new IllegalArgumentException("Unable to coerce parameter " + this.parameters.get(0) + ". Expected " + paramTypes[i] + " but found " + params[i].getClass());
        }
        return actual;
    }

    private String getSignature() {
        return this.getName() + "( " + this.parameters.stream().collect(Collectors.joining(", ")) + " )";
    }

    @Override
    protected boolean isCustomFunction() {
        return true;
    }

    public String toString() {
        return "function " + this.getSignature();
    }
}

