/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.kie.dmn.feel.lang.FEELProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalHelper {
    public static final Logger LOG = LoggerFactory.getLogger(EvalHelper.class);

    public static String normalizeVariableName(String name) {
        return name.replaceAll("\\s+", " ");
    }

    public static BigDecimal getBigDecimalOrNull(Object value) {
        if (!(value instanceof Number)) {
            return null;
        }
        if (!BigDecimal.class.isAssignableFrom(value.getClass())) {
            value = value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof AtomicLong || value instanceof AtomicInteger ? new BigDecimal(((Number)value).longValue(), MathContext.DECIMAL128) : (value instanceof BigInteger ? new BigDecimal(((BigInteger)value).toString(), MathContext.DECIMAL128) : new BigDecimal(((Number)value).doubleValue(), MathContext.DECIMAL128));
        }
        return (BigDecimal)value;
    }

    public static Object coerceNumber(Object value) {
        if (value instanceof Number && !(value instanceof BigDecimal)) {
            return EvalHelper.getBigDecimalOrNull(value);
        }
        return value;
    }

    public static Boolean getBooleanOrNull(Object value) {
        if (value == null || !(value instanceof Boolean)) {
            return null;
        }
        return (Boolean)value;
    }

    public static String unescapeString(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() >= 2 && text.startsWith("\"") && text.endsWith("\"")) {
            text = text.substring(1, text.length() - 1);
        }
        if (text.indexOf(92) >= 0) {
            StringBuilder r = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\\') {
                    if (text.length() <= i + 1) continue;
                    char cn = text.charAt(++i);
                    switch (cn) {
                        case 'b': {
                            r.append('\b');
                            break;
                        }
                        case 't': {
                            r.append('\t');
                            break;
                        }
                        case 'n': {
                            r.append('\n');
                            break;
                        }
                        case 'f': {
                            r.append('\f');
                            break;
                        }
                        case 'r': {
                            r.append('\r');
                            break;
                        }
                        case '\"': {
                            r.append('\"');
                            break;
                        }
                        case '\'': {
                            r.append('\'');
                            break;
                        }
                        case '\\': {
                            r.append('\\');
                            break;
                        }
                        case 'u': {
                            if (text.length() >= i + 5) {
                                String hex = text.substring(i + 1, i + 5);
                                char[] chars = Character.toChars(Integer.parseInt(hex, 16));
                                r.append(chars);
                                i += 4;
                                break;
                            }
                            r.append("\\").append(cn);
                        }
                    }
                    continue;
                }
                r.append(c);
            }
            text = r.toString();
        }
        return text;
    }

    public static Object getValue(Object current, String property) throws IllegalAccessException, InvocationTargetException {
        if (current == null) {
            return null;
        }
        if (current instanceof Map) {
            current = ((Map)current).get(property);
        } else {
            Method getter = EvalHelper.getGenericAccessor(current.getClass(), property);
            current = getter.invoke(current, new Object[0]);
        }
        return EvalHelper.coerceNumber(current);
    }

    public static Method getGenericAccessor(Class<?> clazz, String field) {
        LOG.trace("getGenericAccessor({}, {})", clazz, (Object)field);
        return Stream.of(clazz.getMethods()).filter(m -> Optional.ofNullable(m.getAnnotation(FEELProperty.class)).map(ann -> ann.value().equals(field)).orElse(false)).findFirst().orElse(EvalHelper.getAccessor(clazz, field));
    }

    public static Method getAccessor(Class<?> clazz, String field) {
        LOG.trace("getAccessor({}, {})", clazz, (Object)field);
        try {
            return clazz.getMethod("get" + EvalHelper.ucFirst(field), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(field, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                try {
                    return clazz.getMethod("is" + EvalHelper.ucFirst(field), new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    return null;
                }
            }
        }
    }

    public static Optional<String> propertyFromAccessor(Method accessor) {
        if (accessor.getParameterCount() != 0 || accessor.getReturnType().equals(Void.class)) {
            return Optional.empty();
        }
        String methodName = accessor.getName();
        if (methodName.startsWith("get")) {
            return Optional.of(EvalHelper.lcFirst(methodName.substring(3, methodName.length())));
        }
        if (methodName.startsWith("is")) {
            return Optional.of(EvalHelper.lcFirst(methodName.substring(2, methodName.length())));
        }
        return Optional.of(EvalHelper.lcFirst(methodName));
    }

    public static String ucFirst(String name) {
        return name.toUpperCase().charAt(0) + name.substring(1);
    }

    public static String lcFirst(String name) {
        return name.toLowerCase().charAt(0) + name.substring(1);
    }
}

