/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.feel.util.Msg;

public class QualifiedNameNode
extends BaseNode {
    private List<NameRefNode> parts;

    public QualifiedNameNode(ParserRuleContext ctx, List<NameRefNode> parts) {
        super(ctx);
        this.parts = parts;
    }

    public List<NameRefNode> getParts() {
        return this.parts;
    }

    public void setParts(List<NameRefNode> parts) {
        this.parts = parts;
    }

    public String[] getPartsAsStringArray() {
        return (String[])this.parts.stream().map(p -> p.getText()).toArray(String[]::new);
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        Object current = this.parts.get(0).evaluate(ctx);
        try {
            if (current != null) {
                for (int i = 1; i < this.parts.size(); ++i) {
                    String n = this.parts.get(i).getText();
                    current = EvalHelper.getValue(current, EvalHelper.normalizeVariableName(n));
                }
                return current;
            }
        }
        catch (Exception e) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.ERROR_ACCESSING_QUALIFIED_NAME, this.getText()), e));
            return null;
        }
        return null;
    }
}

