/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.util.Msg;

public class UnaryTestNode
extends BaseNode {
    private UnaryOperator operator;
    private BaseNode value;

    public UnaryTestNode(ParserRuleContext ctx, String op, BaseNode value) {
        super(ctx);
        this.operator = UnaryOperator.determineOperator(op);
        this.value = value;
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(UnaryOperator operator) {
        this.operator = operator;
    }

    public BaseNode getValue() {
        return this.value;
    }

    public void setValue(BaseNode value) {
        this.value = value;
    }

    @Override
    public UnaryTest evaluate(EvaluationContext ctx) {
        switch (this.operator) {
            case LTE: {
                return (c, o) -> {
                    Object val = this.value.evaluate((EvaluationContext)c);
                    return o == null || val == null ? null : Boolean.valueOf(((Comparable)o).compareTo(val) <= 0);
                };
            }
            case LT: {
                return (c, o) -> {
                    Object val = this.value.evaluate((EvaluationContext)c);
                    return o == null || val == null ? null : Boolean.valueOf(((Comparable)o).compareTo(val) < 0);
                };
            }
            case GT: {
                return (c, o) -> {
                    Object val = this.value.evaluate((EvaluationContext)c);
                    return o == null || val == null ? null : Boolean.valueOf(((Comparable)o).compareTo(val) > 0);
                };
            }
            case GTE: {
                return (c, o) -> {
                    Object val = this.value.evaluate((EvaluationContext)c);
                    return o == null || val == null ? null : Boolean.valueOf(((Comparable)o).compareTo(val) >= 0);
                };
            }
            case EQ: {
                return (c, o) -> {
                    Object val = this.value.evaluate((EvaluationContext)c);
                    return o == null || val == null ? null : Boolean.valueOf(((Comparable)o).compareTo(val) == 0);
                };
            }
            case NE: {
                return (c, o) -> {
                    Object val = this.value.evaluate((EvaluationContext)c);
                    return o == null || val == null ? null : Boolean.valueOf(((Comparable)o).compareTo(val) != 0);
                };
            }
            case NOT: {
                return (c, o) -> {
                    Object val = this.value.evaluate((EvaluationContext)c);
                    if (o == null || val == null) {
                        return null;
                    }
                    List tests = (List)val;
                    for (Object test : tests) {
                        if (!(test instanceof UnaryTest ? (Boolean)((UnaryTest)test).apply(c, o) != false : (test instanceof Range ? ((Range)test).includes((Comparable)o) != false : test.equals(o)))) continue;
                        return false;
                    }
                    return true;
                };
            }
        }
        ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.NULL_OR_UNKNOWN_OPERATOR)));
        return null;
    }

    public static enum UnaryOperator {
        LTE("<="),
        LT("<"),
        GT(">"),
        GTE(">="),
        NE("!="),
        EQ("="),
        NOT("not");

        public final String symbol;

        private UnaryOperator(String symbol) {
            this.symbol = symbol;
        }

        public static UnaryOperator determineOperator(String symbol) {
            for (UnaryOperator op : UnaryOperator.values()) {
                if (!op.symbol.equals(symbol)) continue;
                return op;
            }
            throw new IllegalArgumentException("No operator found for symbol '" + symbol + "'");
        }
    }
}

