/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.FEELEventListener;

public class FEELEventListenersManager {
    private Set<FEELEventListener> listeners = new HashSet<FEELEventListener>();

    public void addListener(FEELEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FEELEventListener listener) {
        this.listeners.remove(listener);
    }

    public Set<FEELEventListener> getListeners() {
        return this.listeners;
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void notifyListeners(FEELEvent event) {
        this.listeners.forEach(l -> {
            try {
                l.onEvent(event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public static void notifyListeners(FEELEventListenersManager eventsManager, Supplier<FEELEvent> event) {
        if (eventsManager != null && eventsManager.hasListeners()) {
            eventsManager.notifyListeners(event.get());
        }
    }
}

