/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.decisiontables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.decisiontables.DTDecisionRule;
import org.kie.dmn.feel.runtime.decisiontables.DTInputClause;
import org.kie.dmn.feel.runtime.decisiontables.DTOutputClause;
import org.kie.dmn.feel.runtime.decisiontables.HitPolicy;
import org.kie.dmn.feel.runtime.events.DecisionTableRulesMatchedEvent;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.HitPolicyViolationEvent;
import org.kie.dmn.feel.runtime.events.InvalidInputEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTableImpl {
    private static final Logger logger = LoggerFactory.getLogger(DecisionTableImpl.class);
    private String name;
    private List<String> parameterNames;
    private List<DTInputClause> inputs;
    private List<DTOutputClause> outputs;
    private List<DTDecisionRule> decisionRules;
    private HitPolicy hitPolicy;
    private boolean hasDefaultValues;

    public DecisionTableImpl(String name, List<String> parameterNames, List<DTInputClause> inputs, List<DTOutputClause> outputs, List<DTDecisionRule> decisionRules, HitPolicy hitPolicy) {
        this.name = name;
        this.parameterNames = parameterNames;
        this.inputs = inputs;
        this.outputs = outputs;
        this.decisionRules = decisionRules;
        this.hitPolicy = hitPolicy;
        this.hasDefaultValues = outputs.stream().allMatch(o -> o.getDefaultValue() != null);
    }

    public Object evaluate(EvaluationContext ctx, Object[] params) {
        if (this.decisionRules.isEmpty()) {
            return null;
        }
        FEEL feel = FEEL.newInstance();
        Object[] actualInputs = this.resolveActualInputs(ctx, feel);
        if (!this.actualInputsMatchInputValues(ctx, actualInputs)) {
            return null;
        }
        List<DTDecisionRule> matches = this.findMatches(ctx, actualInputs);
        if (!matches.isEmpty()) {
            List<Object> results = this.evaluateResults(ctx, feel, actualInputs, matches);
            Object result = this.hitPolicy.getDti().dti(ctx, this, actualInputs, matches, results);
            return result;
        }
        if (this.hasDefaultValues) {
            Object result = this.defaultToOutput(ctx, feel);
            return result;
        }
        FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> new HitPolicyViolationEvent(FEELEvent.Severity.ERROR, "No rule matched for decision table '" + this.name + "' and no default values were defined.", this.name, Collections.EMPTY_LIST));
        return null;
    }

    private Object[] resolveActualInputs(EvaluationContext ctx, FEEL feel) {
        Map<String, Object> variables = ctx.getAllValues();
        Object[] actualInputs = new Object[this.inputs.size()];
        for (int i = 0; i < this.inputs.size(); ++i) {
            actualInputs[i] = feel.evaluate(this.inputs.get(i).getInputExpression(), variables);
        }
        return actualInputs;
    }

    private boolean actualInputsMatchInputValues(EvaluationContext ctx, Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            DTInputClause input = this.inputs.get(i);
            if (input.getInputValues() == null || input.getInputValues().isEmpty()) continue;
            Object parameter = params[i];
            boolean satisfies = input.getInputValues().stream().map(ut -> (Boolean)ut.apply(ctx, parameter)).filter(Boolean::booleanValue).findAny().orElse(false);
            if (satisfies) continue;
            FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
                String values = input.getInputValuesText();
                return new InvalidInputEvent(FEELEvent.Severity.ERROR, input.getInputExpression() + "='" + parameter + "' does not match any of the valid values " + values + " for decision table '" + this.getName() + "'.", this.getName(), null, values);
            });
            return false;
        }
        return true;
    }

    private List<DTDecisionRule> findMatches(EvaluationContext ctx, Object[] params) {
        ArrayList<DTDecisionRule> matchingDecisionRules = new ArrayList<DTDecisionRule>();
        for (DTDecisionRule decisionRule : this.decisionRules) {
            if (!this.matches(ctx, params, decisionRule)) continue;
            matchingDecisionRules.add(decisionRule);
        }
        FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
            List<Integer> matches = matchingDecisionRules.stream().map(dr -> dr.getIndex() + 1).collect(Collectors.toList());
            return new DecisionTableRulesMatchedEvent(FEELEvent.Severity.INFO, "Rules matched for decision table '" + this.getName() + "': " + matches.toString(), this.getName(), this.getName(), matches);
        });
        return matchingDecisionRules;
    }

    private boolean matches(EvaluationContext ctx, Object[] params, DTDecisionRule rule) {
        for (int i = 0; i < params.length; ++i) {
            if (this.satisfies(ctx, params[i], rule.getInputEntry().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean satisfies(EvaluationContext ctx, Object param, UnaryTest test) {
        return (Boolean)test.apply(ctx, param);
    }

    private List<Object> evaluateResults(EvaluationContext ctx, FEEL feel, Object[] params, List<DTDecisionRule> matchingDecisionRules) {
        List<Object> results = matchingDecisionRules.stream().map(dr -> this.hitToOutput(ctx, feel, (DTDecisionRule)dr)).collect(Collectors.toList());
        return results;
    }

    private Object hitToOutput(EvaluationContext ctx, FEEL feel, DTDecisionRule rule) {
        List<String> outputEntries = rule.getOutputEntry();
        Map<String, Object> values = ctx.getAllValues();
        if (outputEntries.size() == 1) {
            Object value = feel.evaluate(outputEntries.get(0), values);
            return value;
        }
        return IntStream.range(0, this.outputs.size()).boxed().collect(Collectors.toMap(i -> this.outputs.get((int)i).getName(), i -> feel.evaluate((String)outputEntries.get((int)i), values)));
    }

    private Object defaultToOutput(EvaluationContext ctx, FEEL feel) {
        Map<String, Object> values = ctx.getAllValues();
        if (this.outputs.size() == 1) {
            Object value = feel.evaluate(this.outputs.get(0).getDefaultValue(), values);
            return value;
        }
        return IntStream.range(0, this.outputs.size()).boxed().collect(Collectors.toMap(i -> this.outputs.get((int)i).getName(), i -> feel.evaluate(this.outputs.get((int)i).getDefaultValue(), values)));
    }

    public HitPolicy getHitPolicy() {
        return this.hitPolicy;
    }

    public String getName() {
        return this.name;
    }

    public List<DTOutputClause> getOutputs() {
        return this.outputs;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }
}

