/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.FEELEventBase;
import org.kie.dmn.feel.runtime.events.InvalidInputEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFEELFunction
extends BaseFEELFunction {
    private static final Logger logger = LoggerFactory.getLogger(CustomFEELFunction.class);
    private final List<String> parameters;
    private final BaseNode body;

    public CustomFEELFunction(String name, List<String> parameters, BaseNode body) {
        super(name);
        this.parameters = parameters;
        this.body = body;
    }

    @Override
    public List<List<String>> getParameterNames() {
        return Arrays.asList(this.parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FEELFnResult<Object> invoke(EvaluationContext ctx, Object[] params) {
        if (params.length != this.parameters.size()) {
            return FEELFnResult.ofError(new InvalidInputEvent(FEELEvent.Severity.ERROR, "Illegal invocation of function", this.getName(), this.getName() + "( " + Arrays.asList(params) + " )", this.getSignature()));
        }
        FEELEventBase capturedException = null;
        try {
            ctx.enterFrame();
            for (int i = 0; i < this.parameters.size(); ++i) {
                ctx.setValue(this.parameters.get(i), params[i]);
            }
            Object result = this.body.evaluate(ctx);
            FEELFnResult<Object> fEELFnResult = FEELFnResult.ofResult(result);
            return fEELFnResult;
        }
        catch (Exception e) {
            capturedException = new FEELEventBase(FEELEvent.Severity.ERROR, "Error invoking function", new RuntimeException("Error invoking function " + this.getSignature() + ".", e));
        }
        finally {
            ctx.exitFrame();
        }
        return FEELFnResult.ofError(capturedException);
    }

    private String getSignature() {
        return this.getName() + "( " + this.parameters.stream().collect(Collectors.joining(", ")) + " )";
    }

    @Override
    protected boolean isCustomFunction() {
        return true;
    }

    public String toString() {
        return "function " + this.getSignature();
    }
}

