/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class FlattenFunction
extends BaseFEELFunction {
    public FlattenFunction() {
        super("flatten");
    }

    public FEELFnResult<List> invoke(@ParameterName(value="list") Object list) {
        if (list == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot be null"));
        }
        ArrayList result = new ArrayList();
        this.flattenList(list, result);
        return FEELFnResult.ofResult(result);
    }

    private void flattenList(Object list, List result) {
        if (list instanceof Collection) {
            for (Object element : (Collection)list) {
                if (element instanceof Collection) {
                    this.flattenList(element, result);
                    continue;
                }
                result.add(element);
            }
        } else {
            result.add(list);
        }
    }
}

