/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class SubstringFunction
extends BaseFEELFunction {
    public SubstringFunction() {
        super("substring");
    }

    public FEELFnResult<String> invoke(@ParameterName(value="string") String string, @ParameterName(value="start position") Number start) {
        if (string == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "string", "cannot be null"));
        }
        if (start == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start position", "cannot be null"));
        }
        if (Math.abs(start.intValue()) > string.length()) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "parameter 'start position' inconsistent with parameter 'string' length"));
        }
        if (start.intValue() > 0) {
            return FEELFnResult.ofResult(string.substring(start.intValue() - 1));
        }
        if (start.intValue() < 0) {
            return FEELFnResult.ofResult(string.substring(string.length() + start.intValue()));
        }
        return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start position", "cannot be zero"));
    }

    public FEELFnResult<String> invoke(@ParameterName(value="string") String string, @ParameterName(value="start position") Number start, @ParameterName(value="length") Number length) {
        if (string == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "string", "cannot be null"));
        }
        if (start == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start position", "cannot be null"));
        }
        if (Math.abs(start.intValue()) > string.length()) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "parameter 'start position' inconsistent with parameter 'string' length"));
        }
        if (start.intValue() > 0) {
            return FEELFnResult.ofResult(string.substring(start.intValue() - 1, Math.min(string.length(), start.intValue() + length.intValue() - 1)));
        }
        if (start.intValue() < 0) {
            return FEELFnResult.ofResult(string.substring(string.length() + start.intValue(), Math.min(string.length(), string.length() + start.intValue() + length.intValue())));
        }
        return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "start position", "cannot be zero"));
    }
}

