/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.util.EvalHelper;

public class SumFunction
extends BaseFEELFunction {
    public SumFunction() {
        super("sum");
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="list") List list) {
        BigDecimal sum = BigDecimal.ZERO;
        for (Object element : list) {
            if (element instanceof BigDecimal) {
                sum = sum.add((BigDecimal)element);
                continue;
            }
            if (element instanceof Number) {
                sum = sum.add(EvalHelper.getBigDecimalOrNull(element));
                continue;
            }
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "an element in the list is not suitable for the sum"));
        }
        return FEELFnResult.ofResult(sum);
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="list") Number single) {
        if (single == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "the single value list cannot be null"));
        }
        if (single instanceof BigDecimal) {
            return FEELFnResult.ofResult((BigDecimal)single);
        }
        BigDecimal result = EvalHelper.getBigDecimalOrNull(single);
        if (result != null) {
            return FEELFnResult.ofResult(result);
        }
        return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "single element in list not a number"));
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="n") Object[] list) {
        if (list == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "n", "the single value list cannot be null"));
        }
        return this.invoke(Arrays.asList(list));
    }
}

