/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.types;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInTypeSymbol;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.functions.BuiltInFunctions;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.DateTimeFunction;
import org.kie.dmn.feel.runtime.functions.DurationFunction;
import org.kie.dmn.feel.runtime.functions.NumberFunction;
import org.kie.dmn.feel.runtime.functions.StringFunction;
import org.kie.dmn.feel.runtime.functions.TimeFunction;

public enum BuiltInType implements Type
{
    UNKNOWN("unknown"),
    NUMBER("number"),
    STRING("string"),
    DATE("date"),
    TIME("time"),
    DATE_TIME("date and time", "dateTime"),
    DURATION("duration", "days and time duration", "years and months duration", "dayTimeDuration", "yearMonthDuration"),
    BOOLEAN("boolean"),
    RANGE("range"),
    FUNCTION("function"),
    LIST("list"),
    CONTEXT("context"),
    UNARY_TEST("unary test");

    private final String[] names;
    private final BuiltInTypeSymbol symbol;

    private BuiltInType(String ... names) {
        this.names = names;
        this.symbol = new BuiltInTypeSymbol(names[0], this);
    }

    @Override
    public String getName() {
        return this.names[0];
    }

    public String[] getNames() {
        return this.names;
    }

    @Override
    public Object fromString(String value) {
        switch (this) {
            case NUMBER: {
                return BuiltInFunctions.getFunction(NumberFunction.class).invoke(value, null, null).cata(BuiltInType.justNull(), Function.identity());
            }
            case STRING: {
                return value;
            }
            case DATE: {
                return BuiltInFunctions.getFunction(DateFunction.class).invoke(value).cata(BuiltInType.justNull(), Function.identity());
            }
            case TIME: {
                return BuiltInFunctions.getFunction(TimeFunction.class).invoke(value).cata(BuiltInType.justNull(), Function.identity());
            }
            case DATE_TIME: {
                return BuiltInFunctions.getFunction(DateTimeFunction.class).invoke(value).cata(BuiltInType.justNull(), Function.identity());
            }
            case DURATION: {
                return BuiltInFunctions.getFunction(DurationFunction.class).invoke(value).cata(BuiltInType.justNull(), Function.identity());
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case RANGE: 
            case FUNCTION: 
            case LIST: 
            case CONTEXT: 
            case UNARY_TEST: {
                return FEEL.newInstance().evaluate(value);
            }
        }
        return null;
    }

    @Override
    public String toString(Object value) {
        return (String)BuiltInFunctions.getFunction(StringFunction.class).invoke(value).cata(BuiltInType.justNull(), Function.identity());
    }

    static <T> Function<FEELEvent, T> justNull() {
        return t -> null;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public String toString() {
        return "Type{ " + this.names[0] + " }";
    }

    public static Type determineTypeFromName(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        for (BuiltInType t : BuiltInType.values()) {
            for (String n : t.getNames()) {
                if (!n.equals(name)) continue;
                return t;
            }
        }
        return UNKNOWN;
    }

    public static Type determineTypeFromInstance(Object o) {
        if (o == null) {
            return UNKNOWN;
        }
        if (o instanceof Number) {
            return NUMBER;
        }
        if (o instanceof String) {
            return STRING;
        }
        if (o instanceof LocalDate) {
            return DATE;
        }
        if (o instanceof LocalTime || o instanceof OffsetTime) {
            return TIME;
        }
        if (o instanceof ZonedDateTime || o instanceof OffsetDateTime || o instanceof LocalDateTime) {
            return DATE_TIME;
        }
        if (o instanceof Duration || o instanceof Period) {
            return DURATION;
        }
        if (o instanceof Boolean) {
            return BOOLEAN;
        }
        if (o instanceof UnaryTest) {
            return UNARY_TEST;
        }
        if (o instanceof Range) {
            return RANGE;
        }
        if (o instanceof FEELFunction) {
            return FUNCTION;
        }
        if (o instanceof List) {
            return LIST;
        }
        if (o instanceof Map) {
            return CONTEXT;
        }
        return UNKNOWN;
    }

    public static boolean isInstanceOf(Object o, Type t) {
        return BuiltInType.determineTypeFromInstance(o) == t;
    }

    public static boolean isInstanceOf(Object o, String name) {
        return BuiltInType.determineTypeFromInstance(o) == BuiltInType.determineTypeFromName(name);
    }
}

