/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class YearsAndMonthsFunction
extends BaseFEELFunction {
    public YearsAndMonthsFunction() {
        super("years and months duration");
    }

    public FEELFnResult<TemporalAmount> invoke(@ParameterName(value="from") Temporal from, @ParameterName(value="to") Temporal to) {
        if (from == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        if (to == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        if (!(from instanceof LocalDate)) {
            from = LocalDate.from(from);
        }
        if (!(to instanceof LocalDate)) {
            to = LocalDate.from(to);
        }
        return FEELFnResult.ofResult(Period.between((LocalDate)from, (LocalDate)to).withDays(0));
    }
}

