/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.DashNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.lang.ast.UnaryTestNode;
import org.kie.dmn.feel.lang.impl.CompiledExpressionImpl;
import org.kie.dmn.feel.lang.impl.CompilerContextImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.parser.feel11.ASTBuilderVisitor;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.runtime.UnaryTest;

public class FEELImpl
implements FEEL {
    private static final Map<String, Object> EMPTY_INPUT = Collections.emptyMap();
    private FEELEventListenersManager eventsManager = new FEELEventListenersManager();

    @Override
    public CompilerContext newCompilerContext() {
        return new CompilerContextImpl(this.eventsManager);
    }

    @Override
    public CompiledExpression compile(String expression, CompilerContext ctx) {
        FEEL_1_1Parser parser = FEELParser.parse(this.eventsManager, expression, ctx.getInputVariableTypes(), ctx.getInputVariables());
        FEEL_1_1Parser.Compilation_unitContext tree = parser.compilation_unit();
        ASTBuilderVisitor v = new ASTBuilderVisitor(ctx.getInputVariableTypes());
        BaseNode expr = (BaseNode)v.visit((ParseTree)tree);
        CompiledExpressionImpl ce = new CompiledExpressionImpl(expr);
        return ce;
    }

    public CompiledExpression compileExpressionList(String expression, CompilerContext ctx) {
        FEEL_1_1Parser parser = FEELParser.parse(this.eventsManager, expression, ctx.getInputVariableTypes(), ctx.getInputVariables());
        FEEL_1_1Parser.ExpressionListContext tree = parser.expressionList();
        ASTBuilderVisitor v = new ASTBuilderVisitor(ctx.getInputVariableTypes());
        BaseNode expr = (BaseNode)v.visit((ParseTree)tree);
        CompiledExpressionImpl ce = new CompiledExpressionImpl(expr);
        return ce;
    }

    @Override
    public Object evaluate(String expression) {
        return this.evaluate(expression, EMPTY_INPUT);
    }

    @Override
    public Object evaluate(String expression, Map<String, Object> inputVariables) {
        CompilerContext ctx = this.newCompilerContext();
        if (inputVariables != null) {
            inputVariables.entrySet().stream().forEach(e -> ctx.addInputVariable((String)e.getKey(), e.getValue()));
        }
        CompiledExpression expr = this.compile(expression, ctx);
        if (inputVariables == null) {
            return this.evaluate(expr, EMPTY_INPUT);
        }
        return this.evaluate(expr, inputVariables);
    }

    @Override
    public Object evaluate(CompiledExpression expr, Map<String, Object> inputVariables) {
        return ((CompiledExpressionImpl)expr).evaluate(this.eventsManager, inputVariables);
    }

    @Override
    public List<UnaryTest> evaluateUnaryTests(String expression) {
        return this.evaluateUnaryTests(expression, Collections.emptyMap());
    }

    @Override
    public List<UnaryTest> evaluateUnaryTests(String expression, Map<String, Type> variableTypes) {
        CompilerContext ctx = this.newCompilerContext();
        for (Map.Entry<String, Type> e : variableTypes.entrySet()) {
            ctx.addInputVariableType(e.getKey(), e.getValue());
        }
        CompiledExpressionImpl compiledExpression = (CompiledExpressionImpl)this.compileExpressionList(expression, ctx);
        if (compiledExpression != null) {
            ListNode listNode = (ListNode)compiledExpression.getExpression();
            ArrayList<BaseNode> tests = new ArrayList<BaseNode>();
            for (BaseNode o : listNode.getElements()) {
                if (o == null) continue;
                if (o instanceof UnaryTestNode || o instanceof DashNode) {
                    tests.add(o);
                    continue;
                }
                if (o instanceof RangeNode) {
                    tests.add(new UnaryTestNode("in", o));
                    continue;
                }
                tests.add(new UnaryTestNode("=", o));
            }
            listNode.setElements(tests);
            compiledExpression.setExpression(listNode);
            List uts = (List)this.evaluate(compiledExpression, EMPTY_INPUT);
            return uts;
        }
        return Collections.emptyList();
    }

    @Override
    public void addListener(FEELEventListener listener) {
        this.eventsManager.addListener(listener);
    }

    @Override
    public void removeListener(FEELEventListener listener) {
        this.eventsManager.removeListener(listener);
    }

    @Override
    public Set<FEELEventListener> getListeners() {
        return this.eventsManager.getListeners();
    }

    public FEELEventListenersManager getEventsManager() {
        return this.eventsManager;
    }
}

