/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.parser.feel11;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.kie.dmn.feel.lang.CompositeType;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTBuilderFactory;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.BetweenNode;
import org.kie.dmn.feel.lang.ast.BooleanNode;
import org.kie.dmn.feel.lang.ast.ContextEntryNode;
import org.kie.dmn.feel.lang.ast.DashNode;
import org.kie.dmn.feel.lang.ast.InNode;
import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.kie.dmn.feel.lang.ast.InstanceOfNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.NameDefNode;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.lang.ast.QualifiedNameNode;
import org.kie.dmn.feel.lang.ast.QuantifiedExpressionNode;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.lang.ast.TypeNode;
import org.kie.dmn.feel.lang.ast.UnaryTestNode;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1BaseVisitor;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.parser.feel11.ParserHelper;

public class ASTBuilderVisitor
extends FEEL_1_1BaseVisitor<BaseNode> {
    private ScopeHelper scopeHelper = new ScopeHelper();

    public ASTBuilderVisitor(Map<String, Type> inputTypes) {
        this.scopeHelper.addTypes(inputTypes);
    }

    @Override
    public BaseNode visitNumberLiteral(FEEL_1_1Parser.NumberLiteralContext ctx) {
        return ASTBuilderFactory.newNumberNode(ctx);
    }

    @Override
    public BaseNode visitBooleanLiteral(FEEL_1_1Parser.BooleanLiteralContext ctx) {
        return ASTBuilderFactory.newBooleanNode(ctx);
    }

    @Override
    public BaseNode visitSignedUnaryExpression(FEEL_1_1Parser.SignedUnaryExpressionContext ctx) {
        BaseNode node = (BaseNode)this.visit((ParseTree)ctx.unaryExpression());
        return ASTBuilderFactory.newSignedUnaryNode(ctx, node);
    }

    @Override
    public BaseNode visitNullLiteral(FEEL_1_1Parser.NullLiteralContext ctx) {
        return ASTBuilderFactory.newNullNode(ctx);
    }

    @Override
    public BaseNode visitStringLiteral(FEEL_1_1Parser.StringLiteralContext ctx) {
        return ASTBuilderFactory.newStringNode(ctx);
    }

    @Override
    public BaseNode visitPrimaryParens(FEEL_1_1Parser.PrimaryParensContext ctx) {
        return (BaseNode)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public BaseNode visitLogicalNegation(FEEL_1_1Parser.LogicalNegationContext ctx) {
        NameRefNode name = ASTBuilderFactory.newNameRefNode(ctx.not_key(), BuiltInType.BOOLEAN);
        BaseNode node = (BaseNode)this.visit((ParseTree)ctx.unaryExpression());
        ListNode params = ASTBuilderFactory.newListNode(ctx.unaryExpression(), Arrays.asList(node));
        return this.buildFunctionCall(ctx, name, params);
    }

    @Override
    public BaseNode visitPowExpression(FEEL_1_1Parser.PowExpressionContext ctx) {
        BaseNode left = (BaseNode)this.visit((ParseTree)ctx.powerExpression());
        BaseNode right = (BaseNode)this.visit((ParseTree)ctx.filterPathExpression());
        String op = ctx.op.getText();
        return ASTBuilderFactory.newInfixOpNode(ctx, left, op, right);
    }

    @Override
    public BaseNode visitMultExpression(FEEL_1_1Parser.MultExpressionContext ctx) {
        BaseNode left = (BaseNode)this.visit((ParseTree)ctx.multiplicativeExpression());
        BaseNode right = (BaseNode)this.visit((ParseTree)ctx.powerExpression());
        String op = ctx.op.getText();
        return ASTBuilderFactory.newInfixOpNode(ctx, left, op, right);
    }

    @Override
    public BaseNode visitAddExpression(FEEL_1_1Parser.AddExpressionContext ctx) {
        BaseNode left = (BaseNode)this.visit((ParseTree)ctx.additiveExpression());
        BaseNode right = (BaseNode)this.visit((ParseTree)ctx.multiplicativeExpression());
        String op = ctx.op.getText();
        return ASTBuilderFactory.newInfixOpNode(ctx, left, op, right);
    }

    @Override
    public BaseNode visitRelExpressionBetween(FEEL_1_1Parser.RelExpressionBetweenContext ctx) {
        BaseNode value = (BaseNode)this.visit((ParseTree)ctx.val);
        BaseNode start = (BaseNode)this.visit((ParseTree)ctx.start);
        BaseNode end = (BaseNode)this.visit((ParseTree)ctx.end);
        return ASTBuilderFactory.newBetweenNode(ctx, value, start, end);
    }

    @Override
    public BaseNode visitExpressionList(FEEL_1_1Parser.ExpressionListContext ctx) {
        ArrayList<BaseNode> exprs = new ArrayList<BaseNode>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (!(ctx.getChild(i) instanceof FEEL_1_1Parser.ExpressionContext)) continue;
            exprs.add((BaseNode)this.visit(ctx.getChild(i)));
        }
        return ASTBuilderFactory.newListNode(ctx, exprs);
    }

    @Override
    public BaseNode visitRelExpressionValueList(FEEL_1_1Parser.RelExpressionValueListContext ctx) {
        BaseNode value = (BaseNode)this.visit((ParseTree)ctx.val);
        BaseNode list = (BaseNode)this.visit((ParseTree)ctx.expressionList());
        return ASTBuilderFactory.newInNode(ctx, value, list);
    }

    @Override
    public BaseNode visitInterval(FEEL_1_1Parser.IntervalContext ctx) {
        BaseNode start = (BaseNode)this.visit((ParseTree)ctx.start);
        BaseNode end = (BaseNode)this.visit((ParseTree)ctx.end);
        RangeNode.IntervalBoundary low = ctx.low.getText().equals("[") ? RangeNode.IntervalBoundary.CLOSED : RangeNode.IntervalBoundary.OPEN;
        RangeNode.IntervalBoundary up = ctx.up.getText().equals("]") ? RangeNode.IntervalBoundary.CLOSED : RangeNode.IntervalBoundary.OPEN;
        return ASTBuilderFactory.newIntervalNode(ctx, low, start, end, up);
    }

    @Override
    public BaseNode visitPositiveUnaryTestIneq(FEEL_1_1Parser.PositiveUnaryTestIneqContext ctx) {
        BaseNode value = (BaseNode)this.visit((ParseTree)ctx.endpoint());
        String op = ctx.op.getText();
        return ASTBuilderFactory.newUnaryTestNode(ctx, op, value);
    }

    @Override
    public BaseNode visitSimpleUnaryTests(FEEL_1_1Parser.SimpleUnaryTestsContext ctx) {
        ArrayList<BaseNode> tests = new ArrayList<BaseNode>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (!(ctx.getChild(i) instanceof FEEL_1_1Parser.SimpleUnaryTestContext) && !(ctx.getChild(i) instanceof FEEL_1_1Parser.PrimaryContext)) continue;
            tests.add((BaseNode)this.visit(ctx.getChild(i)));
        }
        return ASTBuilderFactory.newListNode(ctx, tests);
    }

    @Override
    public BaseNode visitRelExpressionTestList(FEEL_1_1Parser.RelExpressionTestListContext ctx) {
        BaseNode value = (BaseNode)this.visit((ParseTree)ctx.val);
        BaseNode list = (BaseNode)this.visit((ParseTree)ctx.simpleUnaryTests());
        return ASTBuilderFactory.newInNode(ctx, value, list);
    }

    @Override
    public BaseNode visitRelExpressionValue(FEEL_1_1Parser.RelExpressionValueContext ctx) {
        BaseNode value = (BaseNode)this.visit((ParseTree)ctx.val);
        BaseNode test = (BaseNode)this.visit((ParseTree)ctx.expression());
        return ASTBuilderFactory.newInNode(ctx, value, test);
    }

    @Override
    public BaseNode visitPositiveUnaryTestNull(FEEL_1_1Parser.PositiveUnaryTestNullContext ctx) {
        return ASTBuilderFactory.newNullNode(ctx);
    }

    @Override
    public BaseNode visitPositiveUnaryTestDash(FEEL_1_1Parser.PositiveUnaryTestDashContext ctx) {
        return ASTBuilderFactory.newDashNode(ctx);
    }

    @Override
    public BaseNode visitCompExpression(FEEL_1_1Parser.CompExpressionContext ctx) {
        BaseNode left = (BaseNode)this.visit((ParseTree)ctx.left);
        BaseNode right = (BaseNode)this.visit((ParseTree)ctx.right);
        return ASTBuilderFactory.newInfixOpNode(ctx, left, ctx.op.getText(), right);
    }

    @Override
    public BaseNode visitCondOr(FEEL_1_1Parser.CondOrContext ctx) {
        BaseNode left = (BaseNode)this.visit((ParseTree)ctx.left);
        BaseNode right = (BaseNode)this.visit((ParseTree)ctx.right);
        return ASTBuilderFactory.newInfixOpNode(ctx, left, ctx.op.getText(), right);
    }

    @Override
    public BaseNode visitCondAnd(FEEL_1_1Parser.CondAndContext ctx) {
        BaseNode left = (BaseNode)this.visit((ParseTree)ctx.left);
        BaseNode right = (BaseNode)this.visit((ParseTree)ctx.right);
        return ASTBuilderFactory.newInfixOpNode(ctx, left, ctx.op.getText(), right);
    }

    @Override
    public BaseNode visitList(FEEL_1_1Parser.ListContext ctx) {
        if (ctx.expressionList() == null) {
            return ASTBuilderFactory.newListNode(ctx, new ArrayList<BaseNode>());
        }
        return (BaseNode)this.visit((ParseTree)ctx.expressionList());
    }

    @Override
    public BaseNode visitNameDefinition(FEEL_1_1Parser.NameDefinitionContext ctx) {
        ArrayList<String> tokenStrs = new ArrayList<String>();
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            this.visit(ctx.getChild(i));
        }
        ParserHelper.getAllTokens((ParseTree)ctx, tokens);
        for (Token t : tokens) {
            tokenStrs.add(t.getText());
        }
        return ASTBuilderFactory.newNameDefNode((ParserRuleContext)ctx, tokenStrs);
    }

    @Override
    public BaseNode visitKeyString(FEEL_1_1Parser.KeyStringContext ctx) {
        return ASTBuilderFactory.newNameDefNode((ParserRuleContext)ctx, ctx.getText());
    }

    @Override
    public BaseNode visitContextEntry(FEEL_1_1Parser.ContextEntryContext ctx) {
        BaseNode name = (BaseNode)this.visit((ParseTree)ctx.key());
        BaseNode value = (BaseNode)this.visit((ParseTree)ctx.expression());
        return ASTBuilderFactory.newContextEntry(ctx, name, value);
    }

    @Override
    public BaseNode visitContextEntries(FEEL_1_1Parser.ContextEntriesContext ctx) {
        ArrayList<BaseNode> nodes = new ArrayList<BaseNode>();
        this.scopeHelper.pushScope();
        for (FEEL_1_1Parser.ContextEntryContext c : ctx.contextEntry()) {
            ContextEntryNode visited = (ContextEntryNode)this.visit((ParseTree)c);
            nodes.add(visited);
            this.scopeHelper.addType(visited.getName().getText(), visited.getResultType());
        }
        this.scopeHelper.popScope();
        return ASTBuilderFactory.newListNode(ctx, nodes);
    }

    @Override
    public BaseNode visitContext(FEEL_1_1Parser.ContextContext ctx) {
        ListNode list = ctx.contextEntries() != null ? (ListNode)this.visit((ParseTree)ctx.contextEntries()) : ASTBuilderFactory.newListNode(ctx, new ArrayList<BaseNode>());
        return ASTBuilderFactory.newContextNode(ctx, list);
    }

    @Override
    public BaseNode visitFormalParameters(FEEL_1_1Parser.FormalParametersContext ctx) {
        ArrayList<BaseNode> list = new ArrayList<BaseNode>();
        for (FEEL_1_1Parser.FormalParameterContext fpc : ctx.formalParameter()) {
            list.add((BaseNode)this.visit((ParseTree)fpc));
        }
        return ASTBuilderFactory.newListNode(ctx, list);
    }

    @Override
    public BaseNode visitFunctionDefinition(FEEL_1_1Parser.FunctionDefinitionContext ctx) {
        ListNode parameters = null;
        if (ctx.formalParameters() != null) {
            parameters = (ListNode)this.visit((ParseTree)ctx.formalParameters());
        }
        boolean external = ctx.external != null;
        BaseNode body = (BaseNode)this.visit((ParseTree)ctx.body);
        return ASTBuilderFactory.newFunctionDefinition(ctx, parameters, external, body);
    }

    @Override
    public BaseNode visitIterationContext(FEEL_1_1Parser.IterationContextContext ctx) {
        NameDefNode name = (NameDefNode)this.visit((ParseTree)ctx.nameDefinition());
        BaseNode expr = (BaseNode)this.visit((ParseTree)ctx.expression());
        return ASTBuilderFactory.newIterationContextNode(ctx, name, expr);
    }

    @Override
    public BaseNode visitIterationContexts(FEEL_1_1Parser.IterationContextsContext ctx) {
        ArrayList<BaseNode> ctxs = new ArrayList<BaseNode>();
        for (FEEL_1_1Parser.IterationContextContext ic : ctx.iterationContext()) {
            ctxs.add((BaseNode)this.visit((ParseTree)ic));
        }
        return ASTBuilderFactory.newListNode(ctx, ctxs);
    }

    @Override
    public BaseNode visitForExpression(FEEL_1_1Parser.ForExpressionContext ctx) {
        ListNode list = (ListNode)this.visit((ParseTree)ctx.iterationContexts());
        BaseNode expr = (BaseNode)this.visit((ParseTree)ctx.expression());
        return ASTBuilderFactory.newForExpression(ctx, list, expr);
    }

    @Override
    public BaseNode visitQualifiedName(FEEL_1_1Parser.QualifiedNameContext ctx) {
        ArrayList<NameRefNode> parts = new ArrayList<NameRefNode>();
        Type typeCursor = null;
        for (FEEL_1_1Parser.NameRefContext t : ctx.nameRef()) {
            String originalText = ParserHelper.getOriginalText(t);
            typeCursor = typeCursor == null ? this.scopeHelper.resolveType(originalText).orElse(BuiltInType.UNKNOWN) : (typeCursor instanceof CompositeType ? ((CompositeType)typeCursor).getFields().get(originalText) : BuiltInType.UNKNOWN);
            parts.add(ASTBuilderFactory.newNameRefNode(t, typeCursor));
        }
        return parts.size() > 1 ? ASTBuilderFactory.newQualifiedNameNode(ctx, parts, typeCursor) : (BaseNode)parts.get(0);
    }

    @Override
    public BaseNode visitIfExpression(FEEL_1_1Parser.IfExpressionContext ctx) {
        BaseNode c = (BaseNode)this.visit((ParseTree)ctx.c);
        BaseNode t = (BaseNode)this.visit((ParseTree)ctx.t);
        BaseNode e = (BaseNode)this.visit((ParseTree)ctx.e);
        return ASTBuilderFactory.newIfExpression(ctx, c, t, e);
    }

    @Override
    public BaseNode visitQuantExprSome(FEEL_1_1Parser.QuantExprSomeContext ctx) {
        ListNode list = (ListNode)this.visit((ParseTree)ctx.iterationContexts());
        BaseNode expr = (BaseNode)this.visit((ParseTree)ctx.expression());
        return ASTBuilderFactory.newQuantifiedExpression(ctx, QuantifiedExpressionNode.Quantifier.SOME, list, expr);
    }

    @Override
    public BaseNode visitQuantExprEvery(FEEL_1_1Parser.QuantExprEveryContext ctx) {
        ListNode list = (ListNode)this.visit((ParseTree)ctx.iterationContexts());
        BaseNode expr = (BaseNode)this.visit((ParseTree)ctx.expression());
        return ASTBuilderFactory.newQuantifiedExpression(ctx, QuantifiedExpressionNode.Quantifier.EVERY, list, expr);
    }

    @Override
    public BaseNode visitNameRef(FEEL_1_1Parser.NameRefContext ctx) {
        return ASTBuilderFactory.newNameRefNode(ctx, BuiltInType.UNKNOWN);
    }

    @Override
    public BaseNode visitPositionalParameters(FEEL_1_1Parser.PositionalParametersContext ctx) {
        ArrayList<BaseNode> params = new ArrayList<BaseNode>();
        for (FEEL_1_1Parser.ExpressionContext ec : ctx.expression()) {
            params.add((BaseNode)this.visit((ParseTree)ec));
        }
        return ASTBuilderFactory.newListNode(ctx, params);
    }

    @Override
    public BaseNode visitNamedParameter(FEEL_1_1Parser.NamedParameterContext ctx) {
        NameDefNode name = (NameDefNode)this.visit((ParseTree)ctx.name);
        BaseNode value = (BaseNode)this.visit((ParseTree)ctx.value);
        return ASTBuilderFactory.newNamedParameterNode(ctx, name, value);
    }

    @Override
    public BaseNode visitNamedParameters(FEEL_1_1Parser.NamedParametersContext ctx) {
        ArrayList<BaseNode> params = new ArrayList<BaseNode>();
        for (FEEL_1_1Parser.NamedParameterContext npc : ctx.namedParameter()) {
            params.add((BaseNode)this.visit((ParseTree)npc));
        }
        return ASTBuilderFactory.newListNode(ctx, params);
    }

    @Override
    public BaseNode visitParametersEmpty(FEEL_1_1Parser.ParametersEmptyContext ctx) {
        return ASTBuilderFactory.newListNode(ctx, new ArrayList<BaseNode>());
    }

    @Override
    public BaseNode visitParametersNamed(FEEL_1_1Parser.ParametersNamedContext ctx) {
        return (BaseNode)this.visit((ParseTree)ctx.namedParameters());
    }

    @Override
    public BaseNode visitParametersPositional(FEEL_1_1Parser.ParametersPositionalContext ctx) {
        return (BaseNode)this.visit((ParseTree)ctx.positionalParameters());
    }

    @Override
    public BaseNode visitPrimaryName(FEEL_1_1Parser.PrimaryNameContext ctx) {
        BaseNode name = (BaseNode)this.visit((ParseTree)ctx.qualifiedName());
        if (ctx.parameters() != null) {
            ListNode params = (ListNode)this.visit((ParseTree)ctx.parameters());
            return this.buildFunctionCall(ctx, name, params);
        }
        return name;
    }

    private String getFunctionName(BaseNode name) {
        String functionName = null;
        if (name instanceof NameRefNode) {
            functionName = name.getText();
        } else {
            QualifiedNameNode qn = (QualifiedNameNode)name;
            functionName = qn.getParts().stream().map(p -> p.getText()).collect(Collectors.joining(" "));
        }
        return functionName;
    }

    private BaseNode buildFunctionCall(ParserRuleContext ctx, BaseNode name, ListNode params) {
        String functionName = this.getFunctionName(name);
        if ("not".equals(functionName)) {
            return this.buildNotCall(ctx, name, params);
        }
        return ASTBuilderFactory.newFunctionInvocationNode(ctx, name, params);
    }

    private BaseNode buildNotCall(ParserRuleContext ctx, BaseNode name, ListNode params) {
        if (params.getElements().size() == 1) {
            BaseNode param = params.getElements().get(0);
            if (param instanceof UnaryTestNode) {
                return ASTBuilderFactory.newUnaryTestNode(ctx, "not", params);
            }
            if (param instanceof BooleanNode) {
                return ASTBuilderFactory.newFunctionInvocationNode(ctx, name, params);
            }
            if (param instanceof NameRefNode) {
                return ASTBuilderFactory.newFunctionInvocationNode(ctx, name, params);
            }
            if (param instanceof QuantifiedExpressionNode) {
                return ASTBuilderFactory.newFunctionInvocationNode(ctx, name, params);
            }
            if (param instanceof InstanceOfNode) {
                return ASTBuilderFactory.newFunctionInvocationNode(ctx, name, params);
            }
            if (param instanceof BetweenNode) {
                return ASTBuilderFactory.newFunctionInvocationNode(ctx, name, params);
            }
            if (param instanceof InNode) {
                return ASTBuilderFactory.newFunctionInvocationNode(ctx, name, params);
            }
            if (param instanceof InfixOpNode && ((InfixOpNode)param).isBoolean()) {
                return ASTBuilderFactory.newFunctionInvocationNode(ctx, name, params);
            }
            if (param instanceof RangeNode) {
                return ASTBuilderFactory.newUnaryTestNode(ctx, "not", params);
            }
            if (param instanceof DashNode) {
                return ASTBuilderFactory.newUnaryTestNode(ctx, "not", params);
            }
            return ASTBuilderFactory.newUnaryTestNode(ctx, "not", params);
        }
        return ASTBuilderFactory.newUnaryTestNode(ctx, "not", params);
    }

    @Override
    public TypeNode visitType(FEEL_1_1Parser.TypeContext ctx) {
        return ASTBuilderFactory.newTypeNode(ctx);
    }

    @Override
    public BaseNode visitRelExpressionInstanceOf(FEEL_1_1Parser.RelExpressionInstanceOfContext ctx) {
        BaseNode expr = (BaseNode)this.visit((ParseTree)ctx.val);
        TypeNode type = (TypeNode)this.visit((ParseTree)ctx.type());
        return ASTBuilderFactory.newInstanceOfNode(ctx, expr, type);
    }

    @Override
    public BaseNode visitFilterPathExpression(FEEL_1_1Parser.FilterPathExpressionContext ctx) {
        if (ctx.filter != null) {
            BaseNode expr = (BaseNode)this.visit((ParseTree)ctx.filterPathExpression());
            BaseNode filter = (BaseNode)this.visit((ParseTree)ctx.filter);
            expr = ASTBuilderFactory.newFilterExpressionNode(ctx, expr, filter);
            return expr;
        }
        if (ctx.qualifiedName() != null) {
            BaseNode expr = (BaseNode)this.visit((ParseTree)ctx.filterPathExpression());
            BaseNode path = (BaseNode)this.visit((ParseTree)ctx.qualifiedName());
            return ASTBuilderFactory.newPathExpressionNode(ctx, expr, path);
        }
        return (BaseNode)this.visit((ParseTree)ctx.unaryExpression());
    }

    @Override
    public BaseNode visitExpressionTextual(FEEL_1_1Parser.ExpressionTextualContext ctx) {
        BaseNode expr = (BaseNode)this.visit((ParseTree)ctx.expr);
        return expr;
    }

    @Override
    public BaseNode visitUenpmPrimary(FEEL_1_1Parser.UenpmPrimaryContext ctx) {
        BaseNode expr = (BaseNode)this.visit((ParseTree)ctx.primary());
        if (ctx.qualifiedName() != null) {
            BaseNode path = (BaseNode)this.visit((ParseTree)ctx.qualifiedName());
            expr = ASTBuilderFactory.newPathExpressionNode(ctx, expr, path);
        }
        return expr;
    }

    @Override
    public BaseNode visitCompilation_unit(FEEL_1_1Parser.Compilation_unitContext ctx) {
        return (BaseNode)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public BaseNode visitNegatedUnaryTests(FEEL_1_1Parser.NegatedUnaryTestsContext ctx) {
        NameRefNode name = ASTBuilderFactory.newNameRefNode(ctx.not_key(), BuiltInType.BOOLEAN);
        ListNode value = (ListNode)this.visit((ParseTree)ctx.simpleUnaryTests());
        return this.buildFunctionCall(ctx, name, value);
    }

    private static class ScopeHelper {
        Deque<Map<String, Type>> stack = new ArrayDeque<Map<String, Type>>();

        public ScopeHelper() {
            this.stack.push(new HashMap());
        }

        public void addTypes(Map<String, Type> inputTypes) {
            this.stack.peek().putAll(inputTypes);
        }

        public void addType(String name, Type type) {
            this.stack.peek().put(name, type);
        }

        public void pushScope() {
            this.stack.push(new HashMap());
        }

        public void popScope() {
            this.stack.pop();
        }

        public Optional<Type> resolveType(String name) {
            return this.stack.stream().map(scope -> Optional.ofNullable(scope.get(name))).flatMap(o -> o.isPresent() ? Stream.of(o.get()) : Stream.empty()).findFirst();
        }
    }
}

