/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.util;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.functions.DateAndTimeFunction;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.TimeFunction;

public final class TypeUtil {
    private static final long SECONDS_IN_A_MINUTE = 60L;
    private static final long SECONDS_IN_AN_HOUR = 3600L;
    private static final long SECONDS_IN_A_DAY = 86400L;
    private static final long NANOSECONDS_PER_SECOND = 1000000000L;

    public static boolean isCollectionTypeHomogenous(Collection collection) {
        if (collection.isEmpty()) {
            return true;
        }
        return TypeUtil.isCollectionTypeHomogenous(collection, collection.iterator().next().getClass());
    }

    public static boolean isCollectionTypeHomogenous(Collection collection, Class expectedType) {
        for (Object object : collection) {
            if (object == null || expectedType.isAssignableFrom(object.getClass())) continue;
            return false;
        }
        return true;
    }

    public static String formatValue(Object val, boolean wrapForCodeUsage) {
        if (val instanceof String) {
            return TypeUtil.formatString(val.toString(), wrapForCodeUsage);
        }
        if (val instanceof LocalDate) {
            return TypeUtil.formatDate((LocalDate)val, wrapForCodeUsage);
        }
        if (val instanceof LocalTime || val instanceof OffsetTime) {
            return TypeUtil.formatTimeString(TimeFunction.FEEL_TIME.format((TemporalAccessor)val), wrapForCodeUsage);
        }
        if (val instanceof LocalDateTime || val instanceof OffsetDateTime) {
            return TypeUtil.formatDateTimeString(DateAndTimeFunction.FEEL_DATE_TIME.format((TemporalAccessor)val), wrapForCodeUsage);
        }
        if (val instanceof ZonedDateTime) {
            TemporalAccessor ta = (TemporalAccessor)val;
            ZoneId zone = ta.query(TemporalQueries.zone());
            if (!(zone instanceof ZoneOffset)) {
                return TypeUtil.formatDateTimeString(DateAndTimeFunction.REGION_DATETIME_FORMATTER.format((TemporalAccessor)val), wrapForCodeUsage);
            }
            return TypeUtil.formatDateTimeString(DateAndTimeFunction.FEEL_DATE_TIME.format((TemporalAccessor)val), wrapForCodeUsage);
        }
        if (val instanceof Duration) {
            return TypeUtil.formatDuration((Duration)val, wrapForCodeUsage);
        }
        if (val instanceof Period) {
            return TypeUtil.formatPeriod((Period)val, wrapForCodeUsage);
        }
        if (val instanceof TemporalAccessor) {
            TemporalAccessor ta = (TemporalAccessor)val;
            if (ta.query(TemporalQueries.localDate()) == null && ta.query(TemporalQueries.localTime()) != null && ta.query(TemporalQueries.zoneId()) != null) {
                return TypeUtil.formatTimeString(TimeFunction.FEEL_TIME.format((TemporalAccessor)val), wrapForCodeUsage);
            }
            return String.valueOf(val);
        }
        if (val instanceof List) {
            return TypeUtil.formatList((List)val, wrapForCodeUsage);
        }
        if (val instanceof Range) {
            return TypeUtil.formatRange((Range)val, wrapForCodeUsage);
        }
        if (val instanceof Map) {
            return TypeUtil.formatContext((Map)val, wrapForCodeUsage);
        }
        return String.valueOf(val);
    }

    public static String formatDateTimeString(String dateTimeString, boolean wrapForCodeUsage) {
        if (wrapForCodeUsage) {
            return "date and time( \"" + dateTimeString + "\" )";
        }
        return dateTimeString;
    }

    public static String formatTimeString(String timeString, boolean wrapForCodeUsage) {
        if (wrapForCodeUsage) {
            return "time( \"" + timeString + "\" )";
        }
        return timeString;
    }

    public static String formatDate(LocalDate date, boolean wrapForCodeUsage) {
        if (wrapForCodeUsage) {
            return "date( \"" + DateFunction.FEEL_DATE.format(date) + "\" )";
        }
        return DateFunction.FEEL_DATE.format(date);
    }

    public static String formatString(String value, boolean wrapForCodeUsage) {
        if (wrapForCodeUsage) {
            return "\"" + value + "\"";
        }
        return value;
    }

    public static String formatList(List list, boolean wrapDateTimeValuesInFunctions) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        int count = 0;
        for (Object val : list) {
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(TypeUtil.formatValue(val, wrapDateTimeValuesInFunctions));
            ++count;
        }
        if (!list.isEmpty()) {
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String formatContext(Map context, boolean wrapDateTimeValuesInFunctions) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        int count = 0;
        for (Map.Entry val : context.entrySet()) {
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(val.getKey());
            sb.append(" : ");
            sb.append(TypeUtil.formatValue(val.getValue(), wrapDateTimeValuesInFunctions));
            ++count;
        }
        if (!context.isEmpty()) {
            sb.append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String formatRange(Range val, boolean wrapDateTimeValuesInFunctions) {
        StringBuilder sb = new StringBuilder();
        sb.append(val.getLowBoundary() == Range.RangeBoundary.OPEN ? "( " : "[ ");
        sb.append(TypeUtil.formatValue(val.getLowEndPoint(), wrapDateTimeValuesInFunctions));
        sb.append(" .. ");
        sb.append(TypeUtil.formatValue(val.getHighEndPoint(), wrapDateTimeValuesInFunctions));
        sb.append(val.getHighBoundary() == Range.RangeBoundary.OPEN ? " )" : " ]");
        return sb.toString();
    }

    public static String formatPeriod(Period period, boolean wrapInDurationFunction) {
        long months;
        long totalMonths = period.toTotalMonths();
        if (totalMonths == 0L) {
            if (wrapInDurationFunction) {
                return "duration( \"P0M\" )";
            }
            return "P0M";
        }
        StringBuilder sb = new StringBuilder();
        if (wrapInDurationFunction) {
            sb.append("duration( \"");
        }
        if (totalMonths < 0L) {
            sb.append("-P");
        } else {
            sb.append('P');
        }
        long years = Math.abs(totalMonths / 12L);
        if (years != 0L) {
            sb.append(years).append('Y');
        }
        if ((months = Math.abs(totalMonths % 12L)) != 0L) {
            sb.append(months).append('M');
        }
        if (wrapInDurationFunction) {
            sb.append("\" )");
        }
        return sb.toString();
    }

    public static String formatDuration(Duration duration, boolean wrapInDurationFunction) {
        if (duration.getSeconds() == 0L && duration.getNano() == 0) {
            if (wrapInDurationFunction) {
                return "duration( \"PT0S\" )";
            }
            return "PT0S";
        }
        long days = duration.getSeconds() / 86400L;
        long hours = duration.getSeconds() % 86400L / 3600L;
        long minutes = duration.getSeconds() % 3600L / 60L;
        long seconds = duration.getSeconds() % 60L;
        StringBuilder sb = new StringBuilder();
        if (wrapInDurationFunction) {
            sb.append("duration( \"");
        }
        if (duration.isNegative()) {
            sb.append("-");
        }
        sb.append("P");
        if (days != 0L) {
            TypeUtil.appendToDurationString(sb, days, "D");
        }
        if (hours != 0L || minutes != 0L || seconds != 0L || duration.getNano() != 0) {
            sb.append("T");
            if (hours != 0L) {
                TypeUtil.appendToDurationString(sb, hours, "H");
            }
            if (minutes != 0L) {
                TypeUtil.appendToDurationString(sb, minutes, "M");
            }
            if (seconds != 0L || duration.getNano() != 0) {
                TypeUtil.appendSecondsToDurationString(sb, seconds, duration.getNano());
            }
        }
        if (wrapInDurationFunction) {
            sb.append("\" )");
        }
        return sb.toString();
    }

    private static void appendToDurationString(StringBuilder sb, long days, String timeSegmentChar) {
        sb.append(Math.abs(days));
        sb.append(timeSegmentChar);
    }

    private static void appendSecondsToDurationString(StringBuilder sb, long seconds, long nanoseconds) {
        if (seconds < 0L && nanoseconds > 0L) {
            if (seconds == -1L) {
                sb.append("0");
            } else {
                sb.append(Math.abs(seconds + 1L));
            }
        } else {
            sb.append(Math.abs(seconds));
        }
        if (nanoseconds > 0L) {
            int pos = sb.length();
            if (seconds < 0L) {
                sb.append(2000000000L - nanoseconds);
            } else {
                sb.append(nanoseconds + 1000000000L);
            }
            TypeUtil.eliminateTrailingZeros(sb);
            sb.setCharAt(pos, '.');
        }
        sb.append('S');
    }

    private static void eliminateTrailingZeros(StringBuilder sb) {
        while (sb.charAt(sb.length() - 1) == '0') {
            sb.setLength(sb.length() - 1);
        }
    }

    private TypeUtil() {
    }
}

